/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ByteUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ArrayConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private final Class<?> targetType;
    private final Class<?> targetComponentType;
    private boolean ignoreElementError;

    public ArrayConverter(Class<?> targetType) {
        this(targetType, false);
    }

    public ArrayConverter(Class<?> targetType, boolean ignoreElementError) {
        if (null == targetType) {
            targetType = Object[].class;
        }
        if (targetType.isArray()) {
            this.targetType = targetType;
            this.targetComponentType = targetType.getComponentType();
        } else {
            this.targetComponentType = targetType;
            this.targetType = ArrayUtil.getArrayType(targetType);
        }
        this.ignoreElementError = ignoreElementError;
    }

    @Override
    protected Object convertInternal(Object value2) {
        return value2.getClass().isArray() ? this.convertArrayToArray(value2) : this.convertObjectToArray(value2);
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    public void setIgnoreElementError(boolean ignoreElementError) {
        this.ignoreElementError = ignoreElementError;
    }

    private Object convertArrayToArray(Object array) {
        Class<?> valueComponentType = ArrayUtil.getComponentType(array);
        if (valueComponentType == this.targetComponentType) {
            return array;
        }
        int len = ArrayUtil.length(array);
        Object result = Array.newInstance(this.targetComponentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, this.convertComponentType(Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Object value2) {
        Object[] result;
        if (value2 instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(value2.toString().toCharArray());
            }
            String[] strings = StrUtil.splitToArray((CharSequence)value2.toString(), ',');
            return this.convertArrayToArray(strings);
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            result = Array.newInstance(this.targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, this.convertComponentType(element));
                ++i;
            }
        } else if (value2 instanceof Iterable) {
            List list = IterUtil.toList((Iterable)value2);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else if (value2 instanceof Iterator) {
            List list = IterUtil.toList((Iterator)value2);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, this.convertComponentType(list.get(i)));
            }
        } else {
            result = value2 instanceof Number && Byte.TYPE == this.targetComponentType ? (Object[])ByteUtil.numberToBytes((Number)value2) : (value2 instanceof Serializable && Byte.TYPE == this.targetComponentType ? (Object[])ObjectUtil.serialize(value2) : this.convertToSingleElementArray(value2));
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Object value2) {
        Object[] singleElementArray = ArrayUtil.newArray(this.targetComponentType, 1);
        singleElementArray[0] = this.convertComponentType(value2);
        return singleElementArray;
    }

    private Object convertComponentType(Object value2) {
        return Convert.convertWithCheck(this.targetComponentType, value2, null, this.ignoreElementError);
    }
}

