/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.serialize;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TemporalAccessorUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONUtil;
import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JSONWriter
extends Writer {
    private final int indentFactor;
    private final int indent;
    private final Writer writer;
    private final JSONConfig config;
    private boolean needSeparator;
    private boolean arrayMode;

    public static JSONWriter of(Writer writer, int indentFactor, int indent, JSONConfig config) {
        return new JSONWriter(writer, indentFactor, indent, config);
    }

    public JSONWriter(Writer writer, int indentFactor, int indent, JSONConfig config) {
        this.writer = writer;
        this.indentFactor = indentFactor;
        this.indent = indent;
        this.config = config;
    }

    public JSONWriter beginObj() {
        this.writeRaw('{');
        return this;
    }

    public JSONWriter beginArray() {
        this.writeRaw('[');
        this.arrayMode = true;
        return this;
    }

    public JSONWriter end() {
        this.writeLF().writeSpace(this.indent);
        this.writeRaw(this.arrayMode ? (char)']' : '}');
        this.flush();
        this.arrayMode = false;
        this.needSeparator = true;
        return this;
    }

    public JSONWriter writeKey(String key) {
        if (this.needSeparator) {
            this.writeRaw(',');
        }
        this.writeLF().writeSpace(this.indentFactor + this.indent);
        return this.writeRaw(JSONUtil.quote(key));
    }

    public JSONWriter writeValue(Object value2) {
        if (JSONUtil.isNull(value2) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeValueDirect(value2);
    }

    public JSONWriter writeField(String key, Object value2) {
        if (JSONUtil.isNull(value2) && this.config.isIgnoreNullValue()) {
            return this;
        }
        return this.writeKey(key).writeValueDirect(value2);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private JSONWriter writeValueDirect(Object value2) {
        if (this.arrayMode) {
            if (this.needSeparator) {
                this.writeRaw(',');
            }
            this.writeLF().writeSpace(this.indentFactor + this.indent);
        } else {
            this.writeRaw(':').writeSpace(1);
        }
        this.needSeparator = true;
        return this.writeObjValue(value2);
    }

    private JSONWriter writeObjValue(Object value2) {
        int indent = this.indentFactor + this.indent;
        if (value2 == null || value2 instanceof JSONNull) {
            this.writeRaw(JSONNull.NULL.toString());
        } else if (value2 instanceof JSON) {
            ((JSON)value2).write(this.writer, this.indentFactor, indent);
        } else if (value2 instanceof Map) {
            new JSONObject(value2).write(this.writer, this.indentFactor, indent);
        } else if (value2 instanceof Iterable || value2 instanceof Iterator || ArrayUtil.isArray(value2)) {
            new JSONArray(value2).write(this.writer, this.indentFactor, indent);
        } else if (value2 instanceof Number) {
            this.writeNumberValue((Number)value2);
        } else if (value2 instanceof Date || value2 instanceof Calendar || value2 instanceof TemporalAccessor) {
            String format = null == this.config ? null : this.config.getDateFormat();
            this.writeRaw(JSONWriter.formatDate(value2, format));
        } else if (value2 instanceof Boolean) {
            this.writeBooleanValue((Boolean)value2);
        } else if (value2 instanceof JSONString) {
            this.writeJSONStringValue((JSONString)value2);
        } else {
            this.writeStrValue(value2.toString());
        }
        return this;
    }

    private void writeNumberValue(Number number) {
        boolean isStripTrailingZeros = null == this.config || this.config.isStripTrailingZeros();
        this.writeRaw(NumberUtil.toStr(number, isStripTrailingZeros));
    }

    private void writeBooleanValue(Boolean value2) {
        this.writeRaw(value2.toString());
    }

    private void writeJSONStringValue(JSONString jsonString) {
        String valueStr;
        try {
            valueStr = jsonString.toJSONString();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        if (null != valueStr) {
            this.writeRaw(valueStr);
        } else {
            this.writeStrValue(jsonString.toString());
        }
    }

    private void writeStrValue(String csq) {
        try {
            JSONUtil.quote(csq, this.writer);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private void writeSpace(int count) {
        if (this.indentFactor > 0) {
            for (int i = 0; i < count; ++i) {
                this.writeRaw(' ');
            }
        }
    }

    private JSONWriter writeLF() {
        if (this.indentFactor > 0) {
            this.writeRaw('\n');
        }
        return this;
    }

    private JSONWriter writeRaw(String csq) {
        try {
            this.writer.append(csq);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    private JSONWriter writeRaw(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    private static String formatDate(Object dateObj, String format) {
        long timeMillis;
        if (StrUtil.isNotBlank(format)) {
            String dateStr = dateObj instanceof TemporalAccessor ? TemporalAccessorUtil.format((TemporalAccessor)dateObj, format) : DateUtil.format(Convert.toDate(dateObj), format);
            if ("#sss".equals(format) || "#SSS".equals(format)) {
                return dateStr;
            }
            return JSONUtil.quote(dateStr);
        }
        if (dateObj instanceof TemporalAccessor) {
            timeMillis = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)dateObj);
        } else if (dateObj instanceof Date) {
            timeMillis = ((Date)dateObj).getTime();
        } else if (dateObj instanceof Calendar) {
            timeMillis = ((Calendar)dateObj).getTimeInMillis();
        } else {
            throw new UnsupportedOperationException("Unsupported Date type: " + dateObj.getClass());
        }
        return String.valueOf(timeMillis);
    }
}

