/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

final class FieldWriterStringField<T>
extends FieldWriter<T> {
    FieldWriterStringField(String fieldName, int ordinal, long features, String format, String label, Field field) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class, field, null);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        String value2 = (String)this.getFieldValue(object);
        if (value2 == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L || (features & JSONWriter.Feature.NotWriteDefaultValue.mask) != 0L) {
                return false;
            }
            if ((features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeString("");
                return true;
            }
        }
        if (this.trim && value2 != null) {
            value2 = value2.trim();
        }
        this.writeFieldName(jsonWriter);
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value2);
        } else if (this.raw) {
            jsonWriter.writeRaw(value2);
        } else {
            jsonWriter.writeString(value2);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String value2 = (String)this.getFieldValue(object);
        if (value2 == null) {
            jsonWriter.writeNull();
            return;
        }
        if (this.trim) {
            value2 = value2.trim();
        }
        if (this.raw) {
            jsonWriter.writeRaw(value2);
        } else {
            jsonWriter.writeString(value2);
        }
    }
}

