/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import java.util.Properties;

public class SystemPropsUtil {
    public static String HUTOOL_DATE_LENIENT = "hutool.date.lenient";

    public static String get(String name, String defaultValue) {
        return StrUtil.nullToDefault(SystemPropsUtil.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        String value2;
        block6: {
            block5: {
                value2 = null;
                try {
                    value2 = System.getProperty(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block5;
                    Console.error("Caught a SecurityException reading the system property '{}'; the SystemUtil property value will default to null.", name);
                }
            }
            if (null == value2) {
                try {
                    value2 = System.getenv(name);
                }
                catch (SecurityException e) {
                    if (quiet) break block6;
                    Console.error("Caught a SecurityException reading the system env '{}'; the SystemUtil env value will default to null.", name);
                }
            }
        }
        return value2;
    }

    public static String get(String key) {
        return SystemPropsUtil.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value2 = SystemPropsUtil.get(key);
        if (value2 == null) {
            return defaultValue;
        }
        if ((value2 = value2.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        return Convert.toBool(value2, defaultValue);
    }

    public static int getInt(String key, int defaultValue) {
        return Convert.toInt(SystemPropsUtil.get(key), defaultValue);
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(SystemPropsUtil.get(key), defaultValue);
    }

    public static Properties getProps() {
        return System.getProperties();
    }

    public static void set(String key, String value2) {
        if (null == value2) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value2);
        }
    }
}

