/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.convert.Converter;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Map;

public abstract class AbstractConverter<T>
implements Converter<T>,
Serializable {
    private static final long serialVersionUID = 1L;

    public T convertQuietly(Object value2, T defaultValue) {
        try {
            return this.convert(value2, defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public T convert(Object value2, T defaultValue) {
        Class<Object> targetType = this.getTargetType();
        if (null == targetType && null == defaultValue) {
            throw new NullPointerException(StrUtil.format("[type] and [defaultValue] are both null for Converter [{}], we can not know what type to convert !", this.getClass().getName()));
        }
        if (null == targetType) {
            targetType = defaultValue.getClass();
        }
        if (null == value2) {
            return defaultValue;
        }
        if (null == defaultValue || targetType.isInstance(defaultValue)) {
            if (targetType.isInstance(value2) && !Map.class.isAssignableFrom(targetType)) {
                return (T)targetType.cast(value2);
            }
            T result = this.convertInternal(value2);
            return null == result ? defaultValue : result;
        }
        throw new IllegalArgumentException(StrUtil.format("Default value [{}]({}) is not the instance of [{}]", defaultValue, defaultValue.getClass(), targetType));
    }

    protected abstract T convertInternal(Object var1);

    protected String convertToStr(Object value2) {
        if (null == value2) {
            return null;
        }
        if (value2 instanceof CharSequence) {
            return value2.toString();
        }
        if (ArrayUtil.isArray(value2)) {
            return ArrayUtil.toString(value2);
        }
        if (CharUtil.isChar(value2)) {
            return CharUtil.toString(((Character)value2).charValue());
        }
        return value2.toString();
    }

    public Class<T> getTargetType() {
        return ClassUtil.getTypeArgument(this.getClass());
    }
}

