/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import com.alibaba.fastjson2.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.Set;

public final class EnumSchema
extends JSONSchema {
    final Set<Object> items;

    EnumSchema(Object ... items) {
        super(null, null);
        this.items = new LinkedHashSet<Object>(items.length);
        for (Object item : items) {
            if (item instanceof BigDecimal) {
                BigInteger bigInt;
                BigDecimal decimal = ((BigDecimal)item).stripTrailingZeros();
                item = decimal.scale() == 0 ? ((bigInt = decimal.toBigInteger()).compareTo(TypeUtils.BIGINT_INT32_MIN) >= 0 && bigInt.compareTo(TypeUtils.BIGINT_INT32_MAX) <= 0 ? (Number)bigInt.intValue() : (Number)(bigInt.compareTo(TypeUtils.BIGINT_INT64_MIN) >= 0 && bigInt.compareTo(TypeUtils.BIGINT_INT64_MAX) <= 0 ? Long.valueOf(bigInt.longValue()) : bigInt)) : decimal;
            }
            this.items.add(item);
        }
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Enum;
    }

    @Override
    public ValidateResult validate(Object value2) {
        long longValue;
        BigInteger bigInt;
        if (value2 instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value2;
            value2 = decimal.stripTrailingZeros();
            long longValue2 = decimal.longValue();
            if (decimal.compareTo(BigDecimal.valueOf(longValue2)) == 0) {
                value2 = longValue2;
            } else if (decimal.scale() == 0) {
                value2 = decimal.unscaledValue();
            }
        } else if (value2 instanceof BigInteger && (bigInt = (BigInteger)value2).compareTo(TypeUtils.BIGINT_INT64_MIN) >= 0 && bigInt.compareTo(TypeUtils.BIGINT_INT64_MAX) <= 0) {
            value2 = bigInt.longValue();
        }
        if (value2 instanceof Long && (longValue = ((Long)value2).longValue()) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
            value2 = (int)longValue;
        }
        if (!this.items.contains(value2)) {
            if (value2 == null) {
                return FAIL_INPUT_NULL;
            }
            return new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Enum, value2.getClass()});
        }
        return SUCCESS;
    }
}

