/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;

final class FieldWriterFloatValField<T>
extends FieldWriter<T> {
    FieldWriterFloatValField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, Float.TYPE, Float.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        return Float.valueOf(this.getFieldValueFloat(object));
    }

    public float getFieldValueFloat(T object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            float value2 = this.fieldOffset != -1L ? JDKUtils.UNSAFE.getFloat(object, this.fieldOffset) : this.field.getFloat(object);
            return value2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        float value2 = this.getFieldValueFloat(object);
        this.writeFloat(jsonWriter, value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        float value2 = this.getFieldValueFloat(object);
        if (this.decimalFormat != null) {
            jsonWriter.writeFloat(value2, this.decimalFormat);
        } else {
            jsonWriter.writeFloat(value2);
        }
    }
}

