/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

final class FieldWriterStringMethod<T>
extends FieldWriter<T> {
    FieldWriterStringMethod(String fieldName, int ordinal, String format, String label, long features, Field field, Method method) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class, field, method);
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke getter method error, " + this.fieldName, e);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String value2 = (String)this.getFieldValue((Object)object);
        if (this.trim && value2 != null) {
            value2 = value2.trim();
        }
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value2);
        } else if (this.raw) {
            jsonWriter.writeRaw(value2);
        } else {
            jsonWriter.writeString(value2);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        String value2;
        try {
            value2 = (String)this.getFieldValue((Object)object);
        }
        catch (JSONException error) {
            if ((jsonWriter.getFeatures(this.features) | JSONWriter.Feature.IgnoreNonFieldGetter.mask) != 0L) {
                return false;
            }
            throw error;
        }
        if (value2 == null && ((features = this.features | jsonWriter.getFeatures()) & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L) {
            return false;
        }
        if (this.trim && value2 != null) {
            value2 = value2.trim();
        }
        this.writeString(jsonWriter, value2);
        return true;
    }
}

