/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Type;
import java.util.function.IntFunction;

public class ObjectReaderImplValueInt<T>
implements ObjectReader<T> {
    final long features;
    final IntFunction<T> function;
    final JSONSchema schema;

    public ObjectReaderImplValueInt(Class<T> objectClass, long features, JSONSchema schema, IntFunction<T> function) {
        this.features = features;
        this.schema = schema;
        this.function = function;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readObject(jsonReader, fieldType, fieldName, features);
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        T object;
        if (jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        int value2 = jsonReader.readInt32Value();
        if (this.schema != null) {
            this.schema.validate((long)value2);
        }
        try {
            object = this.function.apply(value2);
        }
        catch (Exception ex) {
            throw new JSONException(jsonReader.info("create object error"), ex);
        }
        return object;
    }

    public static <T> ObjectReaderImplValueInt<T> of(Class<T> objectClass, IntFunction<T> function) {
        return new ObjectReaderImplValueInt<T>(objectClass, 0L, null, function);
    }

    public static <T> ObjectReaderImplValueInt<T> of(Class<T> objectClass, long features, JSONSchema schema, IntFunction<T> function) {
        return new ObjectReaderImplValueInt<T>(objectClass, features, schema, function);
    }
}

