/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

abstract class FieldWriterInt8<T>
extends FieldWriter<T> {
    FieldWriterInt8(String name, int ordinal, long features, String format, String label, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldClass, fieldClass, field, method);
    }

    protected final void writeInt8(JSONWriter jsonWriter, byte value2) {
        boolean writeNonStringValueAsString;
        boolean bl = writeNonStringValueAsString = (jsonWriter.getFeatures() & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L;
        if (writeNonStringValueAsString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(Byte.toString(value2));
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt8(value2);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Byte value2;
        try {
            value2 = (Byte)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value2 == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeNumberNull();
            return true;
        }
        this.writeInt8(jsonWriter, value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Byte value2 = (Byte)this.getFieldValue(object);
        if (value2 == null) {
            jsonWriter.writeNumberNull();
            return;
        }
        jsonWriter.writeInt32(value2.byteValue());
    }
}

