/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.DependencyException;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelDateUtil;
import cn.hutool.poi.excel.sax.CellDataType;
import cn.hutool.poi.excel.sax.Excel03SaxReader;
import cn.hutool.poi.excel.sax.Excel07SaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.hssf.eventusermodel.FormatTrackingHSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelSaxUtil {
    public static final char CELL_FILL_CHAR = '@';
    public static final int MAX_CELL_BIT = 3;

    public static ExcelSaxReader<?> createSaxReader(boolean isXlsx, RowHandler rowHandler) {
        return isXlsx ? new Excel07SaxReader(rowHandler) : new Excel03SaxReader(rowHandler);
    }

    public static Object getDataValue(CellDataType cellDataType, String value2, SharedStrings sharedStrings, String numFmtString) {
        Object result;
        if (null == value2) {
            return null;
        }
        if (null == cellDataType) {
            cellDataType = CellDataType.NULL;
        }
        switch (cellDataType) {
            case BOOL: {
                result = value2.charAt(0) != '0';
                break;
            }
            case ERROR: {
                result = StrUtil.format("\\\"ERROR: {} ", value2);
                break;
            }
            case FORMULA: {
                result = StrUtil.format("\"{}\"", value2);
                break;
            }
            case INLINESTR: {
                result = new XSSFRichTextString(value2).toString();
                break;
            }
            case SSTINDEX: {
                try {
                    int index = Integer.parseInt(value2);
                    result = sharedStrings.getItemAt(index).getString();
                }
                catch (NumberFormatException e) {
                    result = value2;
                }
                break;
            }
            case NUMBER: {
                try {
                    result = ExcelSaxUtil.getNumberValue(value2, numFmtString);
                }
                catch (NumberFormatException e) {
                    result = value2;
                }
                break;
            }
            case DATE: {
                try {
                    result = ExcelSaxUtil.getDateValue(value2);
                }
                catch (Exception e) {
                    result = value2;
                }
                break;
            }
            default: {
                result = value2;
            }
        }
        return result;
    }

    public static String formatCellContent(String value2, int numFmtIndex, String numFmtString) {
        if (null != numFmtString) {
            try {
                value2 = new DataFormatter().formatRawCellContents(Double.parseDouble(value2), numFmtIndex, numFmtString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value2;
    }

    public static int countNullCell(String preRef, String ref) {
        String preXfd = StrUtil.nullToDefault(preRef, "@").replaceAll("\\d+", "");
        String xfd = StrUtil.nullToDefault(ref, "@").replaceAll("\\d+", "");
        preXfd = StrUtil.fillBefore(preXfd, '@', 3);
        xfd = StrUtil.fillBefore(xfd, '@', 3);
        char[] preLetter = preXfd.toCharArray();
        char[] letter = xfd.toCharArray();
        int res = (letter[0] - preLetter[0]) * 26 * 26 + (letter[1] - preLetter[1]) * 26 + (letter[2] - preLetter[2]);
        return res - 1;
    }

    public static void readFrom(InputStream xmlDocStream, ContentHandler handler) throws DependencyException, POIException, IORuntimeException {
        XMLReader xmlReader;
        try {
            xmlReader = SAXHelper.newXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            if (e.getMessage().contains("org.apache.xerces.parsers.SAXParser")) {
                throw new DependencyException(e, "You need to add 'xerces:xercesImpl' to your project and version >= 2.11.0", new Object[0]);
            }
            throw new POIException(e);
        }
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.parse(new InputSource(xmlDocStream));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (SAXException e) {
            throw new POIException(e);
        }
    }

    public static boolean isDateFormat(CellValueRecordInterface cell, FormatTrackingHSSFListener formatListener) {
        int formatIndex = formatListener.getFormatIndex(cell);
        String formatString = formatListener.getFormatString(cell);
        return ExcelSaxUtil.isDateFormat(formatIndex, formatString);
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        return ExcelDateUtil.isDateFormat(formatIndex, formatString);
    }

    public static DateTime getDateValue(String value2) {
        return ExcelSaxUtil.getDateValue(Double.parseDouble(value2));
    }

    public static DateTime getDateValue(double value2) {
        return DateUtil.date(org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)value2, (boolean)false));
    }

    public static Object getNumberOrDateValue(CellValueRecordInterface cell, double value2, FormatTrackingHSSFListener formatListener) {
        if (ExcelSaxUtil.isDateFormat(cell, formatListener)) {
            return ExcelSaxUtil.getDateValue(value2);
        }
        return ExcelSaxUtil.getNumberValue(value2, formatListener.getFormatString(cell));
    }

    private static Number getNumberValue(String value2, String numFmtString) {
        if (StrUtil.isBlank(value2)) {
            return null;
        }
        return ExcelSaxUtil.getNumberValue(Double.parseDouble(value2), numFmtString);
    }

    private static Number getNumberValue(double numValue, String numFmtString) {
        long longPart;
        if (null != numFmtString && !StrUtil.contains((CharSequence)numFmtString, '.') && (double)(longPart = (long)numValue) == numValue) {
            return longPart;
        }
        return numValue;
    }
}

