/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.base.uitls;

import com.gexin.rp.sdk.base.apns.Payload;
import java.io.UnsupportedEncodingException;

public class ApnsUtils {
    public static final int PAYLOAD_MAX_BYTES = 2048;

    public static int validatePayloadLength(String locKey, String locArgs, String message, String actionLocKey, String launchImage, String badge, String sound, String payload, Integer contentAvailable) {
        Payload pb = ApnsUtils.getPayload(locKey, locArgs, message, actionLocKey, launchImage, badge, sound, payload, contentAvailable);
        return ApnsUtils.validatePayloadLength(pb);
    }

    public static int validatePayloadLength(Payload pb) {
        String json = pb.toString();
        if (json == null) {
            throw new NullPointerException("payload json is null");
        }
        try {
            return json.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("payload json get bytese error", e);
        }
    }

    public static boolean validatePayload(String locKey, String locArgs, String message, String actionLocKey, String launchImage, String badge, String sound, String payload, Integer contentAvailable) {
        int length = ApnsUtils.validatePayloadLength(locKey, locArgs, message, actionLocKey, launchImage, badge, sound, payload, contentAvailable);
        return length <= 2048;
    }

    public static boolean validatePayload(Payload pb) {
        return ApnsUtils.validatePayloadLength(pb) <= 2048;
    }

    public static Payload getPayload(String locKey, String locArgs, String message, String actionLocKey, String launchImage, String badge, String sound, String payload, Integer contentAvailable) {
        boolean isValid = false;
        Payload pb = new Payload();
        if (locKey != null && locKey.length() > 0) {
            pb.setAlertLocKey(locKey);
            if (locArgs != null && locArgs.length() > 0) {
                pb.setAlertLocArgs(locArgs.split(","));
            }
            isValid = true;
        }
        if (message != null && message.length() > 0) {
            pb.setAlertBody(message);
            isValid = true;
        }
        if (actionLocKey != null && actionLocKey.length() > 0) {
            pb.setAlertActionLocKey(actionLocKey);
        }
        if (launchImage != null && launchImage.length() > 0) {
            pb.setAlertLaunchImage(launchImage);
        }
        int badgeNum = -1;
        try {
            badgeNum = Integer.parseInt(badge);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (badgeNum >= 0) {
            pb.setBadge(badgeNum);
            isValid = true;
        }
        if (sound != null && sound.length() > 0) {
            pb.setSound(sound);
        } else {
            pb.setSound("default");
        }
        if (payload != null && payload.length() > 0) {
            pb.addParam("payload", payload);
        }
        if (contentAvailable != null && contentAvailable == 1) {
            pb.setContentAvailable(contentAvailable);
            isValid = true;
        }
        if (!isValid) {
            throw new IllegalArgumentException("one of the params(locKey,message,badge) must not be null or contentAvailable must be 1");
        }
        return pb;
    }
}

