/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.airlift;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.IOUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;

public class SliceValueConsumer
implements ValueConsumer {
    public Slice slice;

    @Override
    public void accept(byte[] bytes, int off, int len) {
        this.slice = Slices.wrappedBuffer((byte[])bytes, (int)off, (int)len);
    }

    @Override
    public void acceptNull() {
        this.slice = null;
    }

    @Override
    public void accept(int value2) {
        int size = value2 < 0 ? IOUtils.stringSize(-value2) + 1 : IOUtils.stringSize(value2);
        byte[] bytes = new byte[size];
        IOUtils.getChars(value2, bytes.length, bytes);
        this.slice = Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public void accept(boolean val) {
        byte[] byArray;
        if (val) {
            byte[] byArray2 = new byte[4];
            byArray2[0] = 116;
            byArray2[1] = 114;
            byArray2[2] = 117;
            byArray = byArray2;
            byArray2[3] = 101;
        } else {
            byte[] byArray3 = new byte[5];
            byArray3[0] = 102;
            byArray3[1] = 97;
            byArray3[2] = 108;
            byArray3[3] = 115;
            byArray = byArray3;
            byArray3[4] = 101;
        }
        byte[] bytes = byArray;
        this.slice = Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public void accept(long value2) {
        int size = value2 < 0L ? IOUtils.stringSize(-value2) + 1 : IOUtils.stringSize(value2);
        byte[] bytes = new byte[size];
        IOUtils.getChars(value2, bytes.length, bytes);
        this.slice = Slices.wrappedBuffer((byte[])bytes);
    }

    @Override
    public void accept(Number val) {
        if (val == null) {
            this.slice = null;
            return;
        }
        if (val instanceof Long) {
            long value2 = val.longValue();
            int size = value2 < 0L ? IOUtils.stringSize(-value2) + 1 : IOUtils.stringSize(value2);
            byte[] bytes = new byte[size];
            IOUtils.getChars(value2, bytes.length, bytes);
            this.slice = Slices.wrappedBuffer((byte[])bytes);
            return;
        }
        if (val instanceof Integer || val instanceof Short || val instanceof Byte) {
            int value3 = val.intValue();
            int size = value3 < 0 ? IOUtils.stringSize(-value3) + 1 : IOUtils.stringSize(value3);
            byte[] bytes = new byte[size];
            IOUtils.getChars(value3, bytes.length, bytes);
            this.slice = Slices.wrappedBuffer((byte[])bytes);
            return;
        }
        String str = val.toString();
        this.slice = Slices.utf8Slice((String)str);
    }

    @Override
    public void accept(String val) {
        this.slice = Slices.utf8Slice((String)val);
    }

    @Override
    public void accept(Map object) {
        if (object.isEmpty()) {
            this.slice = Slices.wrappedBuffer((byte[])new byte[]{123, 125});
            return;
        }
        try (JSONWriter jsonWriter = JSONWriter.ofUTF8();){
            jsonWriter.write(object);
            byte[] bytes = jsonWriter.getBytes();
            this.slice = Slices.wrappedBuffer((byte[])bytes);
        }
    }

    @Override
    public void accept(List array) {
        if (array.isEmpty()) {
            this.slice = Slices.wrappedBuffer((byte[])new byte[]{91, 93});
            return;
        }
        try (JSONWriter jsonWriter = JSONWriter.ofUTF8();){
            jsonWriter.write(array);
            byte[] bytes = jsonWriter.getBytes();
            this.slice = Slices.wrappedBuffer((byte[])bytes);
        }
    }
}

