/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value2) {
        DateTime dateTime;
        if (value2 == null || value2 instanceof CharSequence && StrUtil.isBlank(value2.toString())) {
            return null;
        }
        if (value2 instanceof TemporalAccessor) {
            return this.wrap(DateUtil.date((TemporalAccessor)value2));
        }
        if (value2 instanceof Calendar) {
            return this.wrap(DateUtil.date((Calendar)value2));
        }
        if (value2 instanceof Number) {
            return this.wrap(((Number)value2).longValue());
        }
        String valueStr = this.convertToStr(value2);
        DateTime dateTime2 = dateTime = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
        if (null != dateTime) {
            return this.wrap(dateTime);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value2.getClass().getName(), value2, this.targetType.getName());
    }

    private Date wrap(DateTime date) {
        if (Date.class == this.targetType) {
            return date.toJdkDate();
        }
        if (DateTime.class == this.targetType) {
            return date;
        }
        if (java.sql.Date.class == this.targetType) {
            return date.toSqlDate();
        }
        if (Time.class == this.targetType) {
            return new Time(date.getTime());
        }
        if (Timestamp.class == this.targetType) {
            return date.toTimestamp();
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", this.targetType.getName()));
    }

    private Date wrap(long mills) {
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return DateUtil.date(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", this.targetType.getName()));
    }

    @Override
    public Class<Date> getTargetType() {
        return this.targetType;
    }
}

