/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.matcher.AlwaysTrueValueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayValueMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthValueMatcher;
import cn.hutool.cron.pattern.matcher.ValueMatcher;
import cn.hutool.cron.pattern.matcher.YearValueMatcher;
import cn.hutool.cron.pattern.parser.DayOfMonthValueParser;
import cn.hutool.cron.pattern.parser.ValueParser;
import cn.hutool.cron.pattern.parser.YearValueParser;
import java.util.ArrayList;
import java.util.List;

public class ValueMatcherBuilder {
    public static ValueMatcher build(String value2, ValueParser parser) {
        if (ValueMatcherBuilder.isMatchAllStr(value2)) {
            return new AlwaysTrueValueMatcher();
        }
        List<Integer> values = ValueMatcherBuilder.parseArray(value2, parser);
        if (values.size() == 0) {
            throw new CronException("Invalid field: [{}]", value2);
        }
        if (parser instanceof DayOfMonthValueParser) {
            return new DayOfMonthValueMatcher(values);
        }
        if (parser instanceof YearValueParser) {
            return new YearValueMatcher(values);
        }
        return new BoolArrayValueMatcher(values);
    }

    private static List<Integer> parseArray(String value2, ValueParser parser) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List<String> parts = StrUtil.split((CharSequence)value2, ',');
        for (String part : parts) {
            CollUtil.addAllIfNotContains(values, ValueMatcherBuilder.parseStep(part, parser));
        }
        return values;
    }

    private static List<Integer> parseStep(String value2, ValueParser parser) {
        List<Integer> results;
        List<String> parts = StrUtil.split((CharSequence)value2, '/');
        int size = parts.size();
        if (size == 1) {
            results = ValueMatcherBuilder.parseRange(value2, -1, parser);
        } else if (size == 2) {
            int step = parser.parse(parts.get(1));
            if (step < 1) {
                throw new CronException("Non positive divisor for field: [{}]", value2);
            }
            results = ValueMatcherBuilder.parseRange(parts.get(0), step, parser);
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value2);
        }
        return results;
    }

    private static List<Integer> parseRange(String value2, int step, ValueParser parser) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value2.length() <= 2) {
            int minValue = parser.getMin();
            if (!ValueMatcherBuilder.isMatchAllStr(value2)) {
                minValue = Math.max(minValue, parser.parse(value2));
            } else if (step < 1) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = parser.getMax();
                if (minValue > maxValue) {
                    throw new CronException("Invalid value {} > {}", minValue, maxValue);
                }
                for (int i = minValue; i <= maxValue; i += step) {
                    results.add(i);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List<String> parts = StrUtil.split((CharSequence)value2, '-');
        int size = parts.size();
        if (size == 1) {
            int v1 = parser.parse(value2);
            if (step > 0) {
                NumberUtil.appendRange(v1, parser.getMax(), step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = parser.parse(parts.get(0));
            int v2 = parser.parse(parts.get(1));
            if (step < 1) {
                step = 1;
            }
            if (v1 < v2) {
                NumberUtil.appendRange(v1, v2, step, results);
            } else if (v1 > v2) {
                NumberUtil.appendRange(v1, parser.getMax(), step, results);
                NumberUtil.appendRange(parser.getMin(), v2, step, results);
            } else {
                NumberUtil.appendRange(v1, parser.getMax(), step, results);
            }
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value2);
        }
        return results;
    }

    private static boolean isMatchAllStr(String value2) {
        return 1 == value2.length() && ("*".equals(value2) || "?".equals(value2));
    }
}

