/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;

final class FieldReaderInt16Field<T>
extends FieldReaderObjectField<T> {
    FieldReaderInt16Field(String fieldName, Class fieldType, int ordinal, long features, String format, Short defaultValue, JSONSchema schema, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        int intValue = jsonReader.readInt32Value();
        Short fieldValue = jsonReader.wasNull() ? null : Short.valueOf((short)intValue);
        if (this.schema != null) {
            this.schema.assertValidate(fieldValue);
        }
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, float value2) {
        this.accept(object, (Object)((short)value2));
    }

    @Override
    public void accept(T object, double value2) {
        this.accept(object, (Object)((short)value2));
    }

    @Override
    public void accept(T object, int value2) {
        this.accept(object, (Object)((short)value2));
    }

    @Override
    public void accept(T object, long value2) {
        this.accept(object, (Object)((short)value2));
    }

    @Override
    public void accept(T object, Object value2) {
        Short shortValue = TypeUtils.toShort(value2);
        if (this.schema != null) {
            this.schema.assertValidate(shortValue);
        }
        try {
            this.field.set(object, shortValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return (short)jsonReader.readInt32Value();
    }
}

