/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class Not
extends JSONSchema {
    final JSONSchema schema;
    final JSONSchema.Type[] types;
    final Boolean result;

    public Not(JSONSchema schema, JSONSchema.Type[] types, Boolean result) {
        super(null, null);
        this.schema = schema;
        this.types = types;
        this.result = result;
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.AllOf;
    }

    @Override
    public ValidateResult validate(Object value2) {
        if (this.schema != null && this.schema.validate(value2).isSuccess()) {
            return FAIL_NOT;
        }
        if (this.types != null) {
            block10: for (JSONSchema.Type type : this.types) {
                switch (type) {
                    case String: {
                        if (!(value2 instanceof String)) continue block10;
                        return FAIL_NOT;
                    }
                    case Integer: {
                        if (!(value2 instanceof Byte) && !(value2 instanceof Short) && !(value2 instanceof Integer) && !(value2 instanceof Long) && !(value2 instanceof BigInteger) && !(value2 instanceof AtomicInteger) && !(value2 instanceof AtomicLong)) continue block10;
                        return FAIL_NOT;
                    }
                    case Number: {
                        if (!(value2 instanceof Number)) continue block10;
                        return FAIL_NOT;
                    }
                    case Null: {
                        if (value2 != null) continue block10;
                        return FAIL_NOT;
                    }
                    case Array: {
                        if (!(value2 instanceof Object[]) && !(value2 instanceof Collection) && (value2 == null || !value2.getClass().isArray())) continue block10;
                        return FAIL_NOT;
                    }
                    case Object: {
                        if (value2 instanceof Map) {
                            return FAIL_NOT;
                        }
                        if (value2 == null || !(JSONSchema.CONTEXT.getObjectReader(value2.getClass()) instanceof ObjectReaderBean)) continue block10;
                        return FAIL_NOT;
                    }
                    case Boolean: {
                        if (!(value2 instanceof Boolean)) continue block10;
                        return FAIL_NOT;
                    }
                    case Any: {
                        return FAIL_NOT;
                    }
                }
            }
        }
        if (this.result != null) {
            return this.result != false ? FAIL_NOT : SUCCESS;
        }
        return SUCCESS;
    }
}

