/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import com.gexin.rp.sdk.base.uitls.StringUtils;
import com.gexin.rp.sdk.http.utils.GTConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class OSDomainWrapper {
    private String appKey;
    private List<String> domainUrls;
    private String assignedUrl;
    private String fasterUrl;
    private boolean isSSL;
    private boolean isAssigned;
    private AtomicInteger continuousFailCount = new AtomicInteger(0);
    private long lastTriggerTime = 0L;

    public OSDomainWrapper(String appKey, boolean isSSL, boolean isAssigned, String domainUrl) {
        this.appKey = appKey;
        this.isSSL = isSSL;
        this.isAssigned = isAssigned;
        this.addDomainUrls(domainUrl);
    }

    public void setDomainUrls(List<String> domainUrls) {
        this.domainUrls = domainUrls;
    }

    private void addDomainUrls(String domainUrl) {
        if (StringUtils.isBlank((CharSequence)domainUrl)) {
            this.isAssigned = false;
        } else {
            this.domainUrls = new ArrayList<String>();
            this.domainUrls.add(domainUrl);
            this.assignedUrl = domainUrl;
            this.fasterUrl = domainUrl;
        }
    }

    public boolean isFailCountOverLimit() {
        return this.continuousFailCount.incrementAndGet() >= GTConfig.getHttpFailCount();
    }

    public boolean isNeedTrigger() {
        return this.isFailCountOverLimit() && System.currentTimeMillis() - this.lastTriggerTime > (long)GTConfig.getTriggerInterval();
    }

    public void updateTriggerTime() {
        this.lastTriggerTime = System.currentTimeMillis();
    }

    public void reSetContinuousFailCount() {
        this.continuousFailCount.set(0);
    }

    public void setFasterUrl(String fasterUrl) {
        this.fasterUrl = fasterUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public List<String> getDomainUrls() {
        return this.domainUrls;
    }

    public String getAssignedUrl() {
        return this.assignedUrl;
    }

    public String getFasterUrl() {
        return this.fasterUrl;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OSDomainWrapper{");
        sb.append("appKey='").append(this.appKey).append('\'');
        sb.append(", domainUrls=").append(this.domainUrls);
        sb.append(", assignedUrl='").append(this.assignedUrl).append('\'');
        sb.append(", fasterUrl='").append(this.fasterUrl).append('\'');
        sb.append(", isSSL=").append(this.isSSL);
        sb.append(", isAssigned=").append(this.isAssigned);
        sb.append(", continuousFailCount=").append(this.continuousFailCount);
        sb.append('}');
        return sb.toString();
    }
}

