/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.http;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.BytesResource;
import cn.hutool.core.io.resource.FileResource;
import cn.hutool.core.io.resource.MultiFileResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.net.SSLUtil;
import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.GlobalHeaders;
import cn.hutool.http.Header;
import cn.hutool.http.HttpBase;
import cn.hutool.http.HttpConnection;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpGlobalConfig;
import cn.hutool.http.HttpInterceptor;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpStatus;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import cn.hutool.http.body.BytesBody;
import cn.hutool.http.body.FormUrlEncodedBody;
import cn.hutool.http.body.MultipartBody;
import cn.hutool.http.cookie.GlobalCookieManager;
import java.io.File;
import java.io.IOException;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private UrlBuilder url;
    private URLStreamHandler urlHandler;
    private Method method = Method.GET;
    private final HttpInterceptor.Chain interceptors = new HttpInterceptor.Chain();
    private int connectionTimeout = HttpGlobalConfig.getTimeout();
    private int readTimeout = HttpGlobalConfig.getTimeout();
    private Map<String, Object> form;
    private boolean isMultiPart;
    private String cookie;
    private HttpConnection httpConnection;
    private boolean isDisableCache;
    private boolean isRest;
    private int redirectCount;
    private int maxRedirectCount = HttpGlobalConfig.getMaxRedirectCount();
    private int blockSize;
    private Proxy proxy;
    private HostnameVerifier hostnameVerifier;
    private SSLSocketFactory ssf;

    public static HttpRequest post(String url) {
        return HttpRequest.of(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return HttpRequest.of(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return HttpRequest.of(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return HttpRequest.of(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return HttpRequest.of(url).method(Method.PUT);
    }

    public static HttpRequest patch(String url) {
        return HttpRequest.of(url).method(Method.PATCH);
    }

    public static HttpRequest delete(String url) {
        return HttpRequest.of(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return HttpRequest.of(url).method(Method.TRACE);
    }

    public static HttpRequest of(String url) {
        return HttpRequest.of(url, HttpGlobalConfig.isDecodeUrl() ? DEFAULT_CHARSET : null);
    }

    public static HttpRequest of(String url, Charset charset) {
        return new HttpRequest(UrlBuilder.ofHttp(url, charset));
    }

    public static void setGlobalTimeout(int customTimeout) {
        HttpGlobalConfig.setTimeout(customTimeout);
    }

    public static CookieManager getCookieManager() {
        return GlobalCookieManager.getCookieManager();
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        GlobalCookieManager.setCookieManager(customCookieManager);
    }

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    @Deprecated
    public HttpRequest(String url) {
        this(UrlBuilder.ofHttp(url));
    }

    public HttpRequest(UrlBuilder url) {
        this.url = Assert.notNull(url, "URL must be not null!", new Object[0]);
        Charset charset = url.getCharset();
        if (null != charset) {
            this.charset(charset);
        }
        this.header(GlobalHeaders.INSTANCE.headers);
    }

    public String getUrl() {
        return this.url.toString();
    }

    public HttpRequest setUrl(String url) {
        return this.setUrl(UrlBuilder.ofHttp(url, this.charset));
    }

    public HttpRequest setUrl(UrlBuilder urlBuilder) {
        this.url = urlBuilder;
        return this;
    }

    public HttpRequest setUrlHandler(URLStreamHandler urlHandler) {
        this.urlHandler = urlHandler;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpRequest setMethod(Method method) {
        return this.method(method);
    }

    public HttpConnection getConnection() {
        return this.httpConnection;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return false == "HTTP/1.0".equalsIgnoreCase(this.httpVersion);
        }
        return false == "close".equalsIgnoreCase(connection);
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value2) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value2));
        return this;
    }

    public HttpRequest cookie(Collection<HttpCookie> cookies) {
        return this.cookie(CollUtil.isEmpty(cookies) ? null : cookies.toArray(new HttpCookie[0]));
    }

    public HttpRequest cookie(HttpCookie ... cookies) {
        if (ArrayUtil.isEmpty(cookies)) {
            return this.disableCookie();
        }
        return this.cookie(ArrayUtil.join(cookies, (CharSequence)"; "));
    }

    public HttpRequest cookie(String cookie) {
        this.cookie = cookie;
        return this;
    }

    public HttpRequest disableCookie() {
        return this.cookie("");
    }

    public HttpRequest enableDefaultCookie() {
        return this.cookie((String)null);
    }

    public HttpRequest form(String name, Object value2) {
        String strValue;
        if (StrUtil.isBlank(name) || ObjectUtil.isNull(value2)) {
            return this;
        }
        this.bodyBytes = null;
        if (value2 instanceof File) {
            return this.form(name, (File)value2);
        }
        if (value2 instanceof Resource) {
            return this.form(name, (Resource)value2);
        }
        if (value2 instanceof Iterable) {
            strValue = CollUtil.join((Iterable)value2, (CharSequence)",");
        } else if (ArrayUtil.isArray(value2)) {
            if (File.class == ArrayUtil.getComponentType(value2)) {
                return this.form(name, (File[])value2);
            }
            strValue = ArrayUtil.join((Object[])value2, (CharSequence)",");
        } else {
            strValue = Convert.toStr(value2, null);
        }
        return this.putToForm(name, strValue);
    }

    public HttpRequest form(String name, Object value2, Object ... parameters) {
        this.form(name, value2);
        for (int i = 0; i < parameters.length; i += 2) {
            this.form(parameters[i].toString(), parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        if (MapUtil.isNotEmpty(formMap)) {
            formMap.forEach(this::form);
        }
        return this;
    }

    public HttpRequest formStr(Map<String, String> formMapStr) {
        if (MapUtil.isNotEmpty(formMapStr)) {
            formMapStr.forEach(this::form);
        }
        return this;
    }

    public HttpRequest form(String name, File ... files) {
        if (ArrayUtil.isEmpty(files)) {
            return this;
        }
        if (1 == files.length) {
            File file = files[0];
            return this.form(name, file, file.getName());
        }
        return this.form(name, new MultiFileResource(files));
    }

    public HttpRequest form(String name, File file) {
        return this.form(name, file, file.getName());
    }

    public HttpRequest form(String name, File file, String fileName) {
        if (null != file) {
            this.form(name, new FileResource(file, fileName));
        }
        return this;
    }

    public HttpRequest form(String name, byte[] fileBytes, String fileName) {
        if (null != fileBytes) {
            this.form(name, new BytesResource(fileBytes, fileName));
        }
        return this;
    }

    public HttpRequest form(String name, Resource resource) {
        if (null != resource) {
            if (!this.isKeepAlive()) {
                this.keepAlive(true);
            }
            this.isMultiPart = true;
            return this.putToForm(name, resource);
        }
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public Map<String, Resource> fileForm() {
        HashMap<String, Resource> result = MapUtil.newHashMap();
        this.form.forEach((key, value2) -> {
            if (value2 instanceof Resource) {
                result.put((String)key, (Resource)value2);
            }
        });
        return result;
    }

    public HttpRequest body(String body) {
        return this.body(body, null);
    }

    public HttpRequest body(String body, String contentType) {
        byte[] bytes = StrUtil.bytes((CharSequence)body, this.charset);
        this.body(bytes);
        this.form = null;
        if (null != contentType) {
            this.contentType(contentType);
        } else {
            contentType = HttpUtil.getContentTypeByRequestBody(body);
            if (null != contentType && ContentType.isDefault(this.header(Header.CONTENT_TYPE))) {
                if (null != this.charset) {
                    contentType = ContentType.build(contentType, this.charset);
                }
                this.contentType(contentType);
            }
        }
        if (StrUtil.containsAnyIgnoreCase(contentType, "json", "xml")) {
            this.isRest = true;
            this.contentLength(bytes.length);
        }
        return this;
    }

    public HttpRequest body(byte[] bodyBytes) {
        if (null != bodyBytes) {
            this.bodyBytes = bodyBytes;
        }
        return this;
    }

    public HttpRequest timeout(int milliseconds) {
        this.setConnectionTimeout(milliseconds);
        this.setReadTimeout(milliseconds);
        return this;
    }

    public HttpRequest setConnectionTimeout(int milliseconds) {
        this.connectionTimeout = milliseconds;
        return this;
    }

    public HttpRequest setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
        return this;
    }

    public HttpRequest disableCache() {
        this.isDisableCache = true;
        return this;
    }

    public HttpRequest setFollowRedirects(boolean isFollowRedirects) {
        return this.setMaxRedirectCount(isFollowRedirects ? 2 : 0);
    }

    public HttpRequest setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = Math.max(maxRedirectCount, 0);
        return this;
    }

    public HttpRequest setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest setHttpProxy(String host, int port) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        return this.setProxy(proxy);
    }

    public HttpRequest setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequest setSSLSocketFactory(SSLSocketFactory ssf) {
        this.ssf = ssf;
        return this;
    }

    public HttpRequest setSSLProtocol(String protocol) {
        Assert.notBlank(protocol, "protocol must be not blank!", new Object[0]);
        this.setSSLSocketFactory(SSLUtil.createSSLContext(protocol).getSocketFactory());
        return this;
    }

    public HttpRequest setRest(boolean isRest) {
        this.isRest = isRest;
        return this;
    }

    public HttpRequest setChunkedStreamingMode(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public void addInterceptor(HttpInterceptor interceptor) {
        this.interceptors.addChain(interceptor);
    }

    public HttpResponse execute() {
        return this.execute(false);
    }

    public HttpResponse executeAsync() {
        return this.execute(true);
    }

    public HttpResponse execute(boolean isAsync) {
        return this.doExecute(isAsync, this.interceptors);
    }

    public void then(Consumer<HttpResponse> consumer) {
        try (HttpResponse response = this.execute(true);){
            consumer.accept(response);
        }
    }

    public HttpRequest basicAuth(String username, String password) {
        return this.auth(HttpUtil.buildBasicAuth(username, password, this.charset));
    }

    public HttpRequest basicProxyAuth(String username, String password) {
        return this.proxyAuth(HttpUtil.buildBasicAuth(username, password, this.charset));
    }

    public HttpRequest bearerAuth(String token) {
        return this.auth("Bearer " + token);
    }

    public HttpRequest auth(String content) {
        this.header(Header.AUTHORIZATION, content, true);
        return this;
    }

    public HttpRequest proxyAuth(String content) {
        this.header(Header.PROXY_AUTHORIZATION, content, true);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Request Url: ").append(this.url).append("\r\n");
        sb.append(super.toString());
        return sb.toString();
    }

    private HttpResponse doExecute(boolean isAsync, HttpInterceptor.Chain interceptors) {
        if (null != interceptors) {
            for (HttpInterceptor interceptor : interceptors) {
                interceptor.process(this);
            }
        }
        this.urlWithParamIfGet();
        this.initConnection();
        this.send();
        HttpResponse httpResponse = this.sendRedirectIfPossible(isAsync);
        if (null == httpResponse) {
            httpResponse = new HttpResponse(this.httpConnection, this.charset, isAsync, this.isIgnoreResponseBody());
        }
        return httpResponse;
    }

    private void initConnection() {
        if (null != this.httpConnection) {
            this.httpConnection.disconnectQuietly();
        }
        this.httpConnection = HttpConnection.create(this.url.toURL(this.urlHandler), this.proxy).setConnectTimeout(this.connectionTimeout).setReadTimeout(this.readTimeout).setMethod(this.method).setHttpsInfo(this.hostnameVerifier, this.ssf).setInstanceFollowRedirects(false).setChunkedStreamingMode(this.blockSize).header(this.headers, true);
        if (null != this.cookie) {
            this.httpConnection.setCookie(this.cookie);
        } else {
            GlobalCookieManager.add(this.httpConnection);
        }
        if (this.isDisableCache) {
            this.httpConnection.disableCache();
        }
    }

    private void urlWithParamIfGet() {
        if (Method.GET.equals((Object)this.method) && !this.isRest) {
            if (ArrayUtil.isNotEmpty(this.bodyBytes)) {
                this.url.getQuery().parse(StrUtil.str(this.bodyBytes, this.charset), this.charset);
            } else {
                this.url.getQuery().addAll(this.form);
            }
        }
    }

    private HttpResponse sendRedirectIfPossible(boolean isAsync) {
        if (this.maxRedirectCount > 0) {
            int responseCode;
            try {
                responseCode = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                this.httpConnection.disconnectQuietly();
                throw new HttpException(e);
            }
            if (responseCode != 200 && HttpStatus.isRedirected(responseCode)) {
                this.setUrl(this.httpConnection.header(Header.LOCATION));
                if (this.redirectCount < this.maxRedirectCount) {
                    ++this.redirectCount;
                    return this.doExecute(isAsync, null);
                }
            }
        }
        return null;
    }

    private void send() throws IORuntimeException {
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method) || Method.DELETE.equals((Object)this.method) || this.isRest) {
                if (this.isMultipart()) {
                    this.sendMultipart();
                } else {
                    this.sendFormUrlEncoded();
                }
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            this.httpConnection.disconnectQuietly();
            throw new IORuntimeException(e);
        }
    }

    private void sendFormUrlEncoded() throws IOException {
        if (StrUtil.isBlank(this.header(Header.CONTENT_TYPE))) {
            this.httpConnection.header(Header.CONTENT_TYPE, ContentType.FORM_URLENCODED.toString(this.charset), true);
        }
        BytesBody body = ArrayUtil.isNotEmpty(this.bodyBytes) ? BytesBody.create(this.bodyBytes) : FormUrlEncodedBody.create(this.form, this.charset);
        body.writeClose(this.httpConnection.getOutputStream());
    }

    private void sendMultipart() throws IOException {
        MultipartBody multipartBody = MultipartBody.create(this.form, this.charset);
        this.httpConnection.header(Header.CONTENT_TYPE, multipartBody.getContentType(), true);
        multipartBody.writeClose(this.httpConnection.getOutputStream());
    }

    private boolean isIgnoreResponseBody() {
        return Method.HEAD == this.method || Method.CONNECT == this.method || Method.OPTIONS == this.method || Method.TRACE == this.method;
    }

    private boolean isMultipart() {
        if (this.isMultiPart) {
            return true;
        }
        String contentType = this.header(Header.CONTENT_TYPE);
        return StrUtil.isNotEmpty(contentType) && contentType.startsWith(ContentType.MULTIPART.getValue());
    }

    private HttpRequest putToForm(String name, Object value2) {
        if (null == name || null == value2) {
            return this;
        }
        if (null == this.form) {
            this.form = new LinkedHashMap<String, Object>();
        }
        this.form.put(name, value2);
        return this;
    }
}

