/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Method;
import java.util.function.ObjDoubleConsumer;

final class FieldReaderDoubleValueFunc<T>
extends FieldReader<T> {
    final ObjDoubleConsumer<T> function;

    public FieldReaderDoubleValueFunc(String fieldName, int ordinal, Double defaultValue, JSONSchema schema, Method method, ObjDoubleConsumer<T> function) {
        super(fieldName, Double.TYPE, Double.TYPE, ordinal, 0L, null, null, defaultValue, schema, method, null);
        this.function = function;
    }

    @Override
    public void accept(T object, double value2) {
        if (this.schema != null) {
            this.schema.assertValidate(value2);
        }
        this.function.accept(object, value2);
    }

    @Override
    public void accept(T object, Object value2) {
        double doubleValue = TypeUtils.toDoubleValue(value2);
        if (this.schema != null) {
            this.schema.assertValidate(doubleValue);
        }
        this.function.accept(object, doubleValue);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        double value2 = jsonReader.readDoubleValue();
        if (this.schema != null) {
            this.schema.assertValidate(value2);
        }
        this.function.accept(object, value2);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readDoubleValue();
    }
}

