/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.fastjson.support.spring;

import com.gexin.fastjson.JSON;
import com.gexin.fastjson.parser.Feature;
import com.gexin.fastjson.parser.ParserConfig;
import com.gexin.fastjson.serializer.SerializerFeature;
import com.gexin.fastjson.util.IOUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class GenericFastJsonRedisSerializer
implements RedisSerializer<Object> {
    private static final ParserConfig defaultRedisConfig = new ParserConfig();

    public byte[] serialize(Object object) throws SerializationException {
        if (object == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONBytes(object, SerializerFeature.WriteClassName);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return JSON.parseObject(new String(bytes, IOUtils.UTF8), Object.class, defaultRedisConfig, new Feature[0]);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    static {
        defaultRedisConfig.setAutoTypeSupport(true);
    }
}

