/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONString;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;

public final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    static String valueToString(Object value2) throws JSONException {
        if (value2 == null || value2 instanceof JSONNull) {
            return JSONNull.NULL.toString();
        }
        if (value2 instanceof JSONString) {
            try {
                return ((JSONString)value2).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value2 instanceof Number) {
            return NumberUtil.toStr((Number)value2);
        }
        if (value2 instanceof Boolean || value2 instanceof JSONObject || value2 instanceof JSONArray) {
            return value2.toString();
        }
        if (value2 instanceof Map) {
            Map map = (Map)value2;
            return new JSONObject(map).toString();
        }
        if (value2 instanceof Collection) {
            Collection coll = (Collection)value2;
            return new JSONArray((Object)coll).toString();
        }
        if (ArrayUtil.isArray(value2)) {
            return new JSONArray(value2).toString();
        }
        return JSONUtil.quote(value2.toString());
    }

    public static Object stringToValue(String string) {
        if (StrUtil.isEmpty(string) || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase(string, ".", "e")) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value2) {
        String[] path = StrUtil.splitToArray((CharSequence)Convert.toStr(key), '.');
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.getConfig());
                target.set(segment, nextTarget);
            }
            target = nextTarget;
        }
        target.set(path[last], value2);
        return jsonObject;
    }

    static boolean defaultIgnoreNullValue(Object obj) {
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == obj instanceof Map;
    }

    static boolean isOrder(Object value2) {
        JSONConfig config;
        if (value2 instanceof LinkedHashMap || value2 instanceof SortedMap) {
            return true;
        }
        if (value2 instanceof JSONGetter && null != (config = ((JSONGetter)value2).getConfig())) {
            return config.isOrder();
        }
        return false;
    }
}

