/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class JSONArray
extends ArrayList<Object> {
    private static final long serialVersionUID = 1L;
    static ObjectWriter<JSONArray> arrayWriter;

    public JSONArray() {
    }

    public JSONArray(int initialCapacity) {
        super(initialCapacity);
    }

    public JSONArray(Collection<?> collection) {
        super(collection);
    }

    public JSONArray(Object ... items) {
        super(items.length);
        super.addAll(Arrays.asList(items));
    }

    @Override
    public Object set(int index, Object element) {
        int size = super.size();
        if (index < 0) {
            if ((index += size) < 0) {
                super.add(0, element);
                return null;
            }
            return super.set(index, element);
        }
        if (index < size) {
            return super.set(index, element);
        }
        if (index < size + 4096) {
            while (index-- != size) {
                super.add(null);
            }
            super.add(element);
        }
        return null;
    }

    public JSONArray getJSONArray(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof JSONArray) {
            return (JSONArray)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            return JSONFactory.ARRAY_READER.readObject(reader, null, null, 0L);
        }
        if (value2 instanceof Collection) {
            JSONArray array = new JSONArray((Collection<?>)((Collection)value2));
            this.set(index, array);
            return array;
        }
        if (value2 instanceof Object[]) {
            return JSONArray.of((Object[])value2);
        }
        Class<?> valueClass = value2.getClass();
        if (valueClass.isArray()) {
            int length = Array.getLength(value2);
            JSONArray jsonArray = new JSONArray(length);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value2, i);
                jsonArray.add(item);
            }
            return jsonArray;
        }
        return null;
    }

    public JSONObject getJSONObject(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof JSONObject) {
            return (JSONObject)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            JSONReader reader = JSONReader.of(str);
            return JSONFactory.OBJECT_READER.readObject(reader, null, null, 0L);
        }
        if (value2 instanceof Map) {
            JSONObject object = new JSONObject((Map)value2);
            this.set(index, object);
            return object;
        }
        Class<?> valueClass = value2.getClass();
        ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(valueClass);
        if (objectWriter instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter writerAdapter = (ObjectWriterAdapter)objectWriter;
            return writerAdapter.toJSONObject(value2);
        }
        return null;
    }

    public String getString(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        if (value2 instanceof Date) {
            long timeMillis = ((Date)value2).getTime();
            return DateUtils.toString(timeMillis, false, DateUtils.DEFAULT_ZONE_ID);
        }
        if (value2 instanceof Boolean || value2 instanceof Character || value2 instanceof Number || value2 instanceof UUID || value2 instanceof Enum || value2 instanceof TemporalAccessor) {
            return value2.toString();
        }
        return JSON.toJSONString(value2);
    }

    public Double getDouble(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Double");
    }

    public double getDoubleValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0.0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).doubleValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0;
            }
            return Double.parseDouble(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to double value");
    }

    public Float getFloat(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Float) {
            return (Float)value2;
        }
        if (value2 instanceof Number) {
            return Float.valueOf(((Number)value2).floatValue());
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Float.valueOf(Float.parseFloat(str));
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Float");
    }

    public float getFloatValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0.0f;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).floatValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to float value");
    }

    public Long getLong(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Long");
    }

    public long getLongValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0L;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0L;
            }
            return Long.parseLong(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to long value");
    }

    public Integer getInteger(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Integer");
    }

    public int getIntValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Integer.parseInt(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to int value");
    }

    public Short getShort(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Short) {
            return (Short)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).shortValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Short");
    }

    public short getShortValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).shortValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Short.parseShort(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to short value");
    }

    public Byte getByte(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).byteValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Byte");
    }

    public byte getByteValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return 0;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).byteValue();
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return 0;
            }
            return Byte.parseByte(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to byte value");
    }

    public Boolean getBoolean(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue() == 1;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to Boolean");
    }

    public boolean getBooleanValue(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof Number) {
            return ((Number)value2).intValue() == 1;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            return "true".equalsIgnoreCase(str) || "1".equals(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to boolean value");
    }

    public BigInteger getBigInteger(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            if (value2 instanceof BigInteger) {
                return (BigInteger)value2;
            }
            if (value2 instanceof BigDecimal) {
                return ((BigDecimal)value2).toBigInteger();
            }
            long longValue = ((Number)value2).longValue();
            return BigInteger.valueOf(longValue);
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equalsIgnoreCase(str)) {
                return null;
            }
            return new BigInteger(str);
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to BigInteger");
    }

    public BigDecimal getBigDecimal(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Number) {
            if (value2 instanceof BigDecimal) {
                return (BigDecimal)value2;
            }
            if (value2 instanceof BigInteger) {
                return new BigDecimal((BigInteger)value2);
            }
            if (value2 instanceof Float) {
                float floatValue = ((Float)value2).floatValue();
                return TypeUtils.toBigDecimal(floatValue);
            }
            if (value2 instanceof Double) {
                double doubleValue = (Double)value2;
                return TypeUtils.toBigDecimal(doubleValue);
            }
            long longValue = ((Number)value2).longValue();
            return BigDecimal.valueOf(longValue);
        }
        if (value2 instanceof String) {
            return TypeUtils.toBigDecimal((String)value2);
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2 != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        throw new JSONException("Can not cast '" + value2.getClass() + "' to BigDecimal");
    }

    public Date getDate(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Date) {
            return (Date)value2;
        }
        if (value2 instanceof Number) {
            long millis = ((Number)value2).longValue();
            if (millis == 0L) {
                return null;
            }
            return new Date(millis);
        }
        return TypeUtils.toDate(value2);
    }

    public Date getDate(int index, Date defaultValue) {
        Date date = this.getDate(index);
        if (date == null) {
            date = defaultValue;
        }
        return date;
    }

    public Instant getInstant(int index) {
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof Instant) {
            return (Instant)value2;
        }
        if (value2 instanceof Number) {
            long millis = ((Number)value2).longValue();
            if (millis == 0L) {
                return null;
            }
            return Instant.ofEpochMilli(millis);
        }
        return TypeUtils.toInstant(value2);
    }

    @Override
    public String toString() {
        try (JSONWriter writer = JSONWriter.of();){
            writer.setRootObject(this);
            writer.write(this);
            String string = writer.toString();
            return string;
        }
    }

    public String toString(JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.of(features);){
            if ((writer.context.features & JSONObject.NONE_DIRECT_FEATURES) == 0L) {
                writer.write(this);
            } else {
                writer.setRootObject(this);
                if (arrayWriter == null) {
                    arrayWriter = writer.getObjectWriter((Type)((Object)JSONArray.class), JSONArray.class);
                }
                arrayWriter.write(writer, this, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public String toJSONString(JSONWriter.Feature ... features) {
        return this.toString(features);
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        return JSON.toJSONString(object, features);
    }

    public byte[] toJSONBBytes(JSONWriter.Feature ... features) {
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.setRootObject(this);
            writer.write(this);
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public <T> T to(Type type) {
        if (type == String.class) {
            return (T)this.toString();
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(type);
        return objectReader.createInstance(this);
    }

    public <T> T to(Class<T> type) {
        if (type == String.class) {
            return (T)this.toString();
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(type);
        return objectReader.createInstance(this);
    }

    @Deprecated
    public <T> T toJavaObject(Type type) {
        return this.to(type);
    }

    public <T> List<T> toList(Class<T> itemClass, JSONReader.Feature ... features) {
        boolean fieldBased = false;
        long featuresValue = 0L;
        for (JSONReader.Feature feature : features) {
            featuresValue |= feature.mask;
            if (feature != JSONReader.Feature.FieldBased) continue;
            fieldBased = true;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(itemClass, fieldBased);
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            Object classItem;
            Object item = this.get(i);
            if (item instanceof JSONObject) {
                classItem = objectReader.createInstance((Map)item, featuresValue);
            } else if (item instanceof Map) {
                classItem = objectReader.createInstance((Map)item, featuresValue);
            } else if (item == null || itemClass.isInstance(item)) {
                classItem = item;
            } else {
                Class<?> currentItemClass = item.getClass();
                Function typeConvert = provider.getTypeConvert(currentItemClass, itemClass);
                if (typeConvert != null) {
                    Object converted = typeConvert.apply(item);
                    list.add(converted);
                    continue;
                }
                throw new JSONException(currentItemClass + " cannot be converted to " + itemClass);
            }
            list.add(classItem);
        }
        return list;
    }

    public <T> T[] toArray(Class<T> itemClass, JSONReader.Feature ... features) {
        boolean fieldBased = false;
        long featuresValue = 0L;
        for (JSONReader.Feature feature : features) {
            featuresValue |= feature.mask;
            if (feature != JSONReader.Feature.FieldBased) continue;
            fieldBased = true;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        ObjectReader objectReader = provider.getObjectReader(itemClass, fieldBased);
        Object[] list = (Object[])Array.newInstance(itemClass, this.size());
        for (int i = 0; i < this.size(); ++i) {
            Object classItem;
            Object item = this.get(i);
            if (item instanceof JSONObject) {
                classItem = objectReader.createInstance((Map)item, featuresValue);
            } else if (item instanceof Map) {
                classItem = objectReader.createInstance((Map)item, featuresValue);
            } else if (item == null || itemClass.isInstance(item)) {
                classItem = item;
            } else {
                Class<?> currentItemClass = item.getClass();
                Function typeConvert = provider.getTypeConvert(currentItemClass, itemClass);
                if (typeConvert != null) {
                    Object converted = typeConvert.apply(item);
                    list[i] = converted;
                    continue;
                }
                throw new JSONException(currentItemClass + " cannot be converted to " + itemClass);
            }
            list[i] = classItem;
        }
        return list;
    }

    public <T> List<T> toJavaList(Class<T> clazz, JSONReader.Feature ... features) {
        return this.toList(clazz, features);
    }

    public <T> T getObject(int index, Type type, JSONReader.Feature ... features) {
        ObjectReader objectReader;
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        Class<?> valueClass = value2.getClass();
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(valueClass, type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(value2);
        }
        boolean fieldBased = false;
        long featuresValue = 0L;
        for (JSONReader.Feature feature : features) {
            featuresValue |= feature.mask;
            if (feature != JSONReader.Feature.FieldBased) continue;
            fieldBased = true;
        }
        if (value2 instanceof Map) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Map)value2, featuresValue);
        }
        if (value2 instanceof Collection) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Collection)value2);
        }
        Class<?> clazz = TypeUtils.getMapping(type);
        if (clazz.isInstance(value2)) {
            return (T)value2;
        }
        String json = JSON.toJSONString(value2);
        JSONReader jsonReader = JSONReader.of(json);
        jsonReader.context.config(features);
        ObjectReader objectReader2 = provider.getObjectReader(clazz, fieldBased);
        return objectReader2.readObject(jsonReader, null, null, 0L);
    }

    public <T> T getObject(int index, Class<T> type, JSONReader.Feature ... features) {
        ObjectReader objectReader;
        Object value2 = this.get(index);
        if (value2 == null) {
            return null;
        }
        Class<?> valueClass = value2.getClass();
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Function typeConvert = provider.getTypeConvert(valueClass, type);
        if (typeConvert != null) {
            return (T)typeConvert.apply(value2);
        }
        boolean fieldBased = false;
        long featuresValue = 0L;
        for (JSONReader.Feature feature : features) {
            featuresValue |= feature.mask;
            if (feature != JSONReader.Feature.FieldBased) continue;
            fieldBased = true;
        }
        if (value2 instanceof Map) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Map)value2, featuresValue);
        }
        if (value2 instanceof Collection) {
            objectReader = provider.getObjectReader(type, fieldBased);
            return objectReader.createInstance((Collection)value2);
        }
        Class<?> clazz = TypeUtils.getMapping(type);
        if (clazz.isInstance(value2)) {
            return (T)value2;
        }
        ObjectReader objectReader2 = null;
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.isEmpty() || "null".equals(str)) {
                return null;
            }
            if (clazz.isEnum() && (objectReader2 = provider.getObjectReader(clazz, fieldBased)) instanceof ObjectReaderImplEnum) {
                long hashCode64 = Fnv.hashCode64(str);
                ObjectReaderImplEnum enumReader = (ObjectReaderImplEnum)objectReader2;
                return (T)enumReader.getEnumByHashCode(hashCode64);
            }
        }
        String json = JSON.toJSONString(value2);
        JSONReader jsonReader = JSONReader.of(json);
        jsonReader.context.config(features);
        if (objectReader2 == null) {
            objectReader2 = provider.getObjectReader(clazz, fieldBased);
        }
        Object object = objectReader2.readObject(jsonReader, null, null, 0L);
        if (!jsonReader.isEnd()) {
            throw new JSONException("not support input " + json);
        }
        return object;
    }

    public <T> T getObject(int index, Function<JSONObject, T> creator) {
        JSONObject object = this.getJSONObject(index);
        if (object == null) {
            return null;
        }
        return creator.apply(object);
    }

    public JSONObject addObject() {
        JSONObject object = new JSONObject();
        this.add(object);
        return object;
    }

    public JSONArray addArray() {
        JSONArray array = new JSONArray();
        this.add(array);
        return array;
    }

    public JSONArray fluentAdd(Object element) {
        this.add(element);
        return this;
    }

    public JSONArray fluentClear() {
        this.clear();
        return this;
    }

    public JSONArray fluentRemove(int index) {
        this.remove(index);
        return this;
    }

    public JSONArray fluentSet(int index, Object element) {
        this.set(index, element);
        return this;
    }

    public JSONArray fluentRemove(Object o) {
        this.remove(o);
        return this;
    }

    public JSONArray fluentRemoveAll(Collection<?> c) {
        this.removeAll(c);
        return this;
    }

    public JSONArray fluentAddAll(Collection<?> c) {
        this.addAll(c);
        return this;
    }

    public boolean isValid(JSONSchema schema) {
        return schema.validate(this).isSuccess();
    }

    @Override
    public Object clone() {
        return new JSONArray((Collection<?>)this);
    }

    public static JSONArray of(Object ... items) {
        return new JSONArray(items);
    }

    public static JSONArray of(Object item) {
        JSONArray array = new JSONArray(1);
        array.add(item);
        return array;
    }

    public static JSONArray copyOf(Collection collection) {
        return new JSONArray((Collection<?>)collection);
    }

    public static JSONArray of(Object first, Object second) {
        JSONArray array = new JSONArray(2);
        array.add(first);
        array.add(second);
        return array;
    }

    public static JSONArray of(Object first, Object second, Object third) {
        JSONArray array = new JSONArray(3);
        array.add(first);
        array.add(second);
        array.add(third);
        return array;
    }

    public static JSONArray parseArray(String text, JSONReader.Feature ... features) {
        return JSON.parseArray(text, features);
    }

    public static <T> List<T> parseArray(String text, Class<T> type, JSONReader.Feature ... features) {
        return JSON.parseArray(text, type, features);
    }

    public static JSONArray parse(String text, JSONReader.Feature ... features) {
        return JSON.parseArray(text, features);
    }

    public static <T> List<T> parseArray(String input, Class<T> type) {
        return JSON.parseArray(input, type);
    }

    public static JSONArray from(Object obj) {
        return (JSONArray)JSON.toJSON(obj);
    }

    public static JSONArray from(Object obj, JSONWriter.Feature ... writeFeatures) {
        return (JSONArray)JSON.toJSON(obj, writeFeatures);
    }
}

