/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTwoSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.util.function.BiFunction;

public class JSONPathCompilerReflect
implements JSONFactory.JSONPathCompiler {
    static final JSONPathCompilerReflect INSTANCE = new JSONPathCompilerReflect();

    @Override
    public JSONPath compile(Class objectClass, JSONPath path) {
        if (path instanceof JSONPathSingleName) {
            return this.compileSingleNamePath(objectClass, (JSONPathSingleName)path);
        }
        if (path instanceof JSONPathTwoSegment) {
            JSONPathTwoSegment twoSegmentPath = (JSONPathTwoSegment)path;
            JSONPathSegment first = this.compile(objectClass, path, twoSegmentPath.first, null);
            JSONPathSegment segment = this.compile(objectClass, path, twoSegmentPath.second, first);
            if (first != twoSegmentPath.first || segment != twoSegmentPath.second) {
                if (first instanceof NameSegmentTyped && segment instanceof NameSegmentTyped) {
                    return new TwoNameSegmentTypedPath(twoSegmentPath.path, (NameSegmentTyped)first, (NameSegmentTyped)segment);
                }
                return new JSONPathTwoSegment(twoSegmentPath.path, first, segment, new JSONPath.Feature[0]);
            }
        }
        return path;
    }

    protected JSONPath compileSingleNamePath(Class objectClass, JSONPathSingleName path) {
        String fieldName = path.name;
        ObjectReader objectReader = path.getReaderContext().getObjectReader(objectClass);
        FieldReader fieldReader = objectReader.getFieldReader(fieldName);
        ObjectWriter objectWriter = path.getWriterContext().getObjectWriter(objectClass);
        FieldWriter fieldWriter = objectWriter.getFieldWriter(fieldName);
        return new SingleNamePathTyped(path.path, objectClass, objectReader, fieldReader, objectWriter, fieldWriter);
    }

    protected JSONPathSegment compile(Class objectClass, JSONPath path, JSONPathSegment segment, JSONPathSegment parent) {
        if (segment instanceof JSONPathSegmentName) {
            JSONPathSegmentName nameSegment = (JSONPathSegmentName)segment;
            String fieldName = nameSegment.name;
            JSONReader.Context readerContext = path.getReaderContext();
            JSONWriter.Context writerContext = path.getWriterContext();
            ObjectReader objectReader = null;
            FieldReader fieldReader = null;
            if (parent == null) {
                objectReader = readerContext.getObjectReader(objectClass);
            } else if (parent instanceof NameSegmentTyped) {
                NameSegmentTyped nameSegmentTyped = (NameSegmentTyped)parent;
                if (nameSegmentTyped.fieldReader != null) {
                    objectReader = readerContext.getObjectReader(nameSegmentTyped.fieldReader.fieldType);
                }
            }
            if (objectReader != null) {
                fieldReader = objectReader.getFieldReader(fieldName);
            }
            ObjectWriter objectWriter = null;
            FieldWriter fieldWriter = null;
            if (parent == null) {
                objectWriter = writerContext.getObjectWriter(objectClass);
            } else if (parent instanceof NameSegmentTyped) {
                NameSegmentTyped nameSegmentTyped = (NameSegmentTyped)parent;
                if (nameSegmentTyped.fieldWriter != null) {
                    objectWriter = writerContext.getObjectWriter(nameSegmentTyped.fieldWriter.fieldClass);
                }
            }
            if (objectWriter != null) {
                fieldWriter = objectWriter.getFieldWriter(fieldName);
            }
            return new NameSegmentTyped(objectClass, objectReader, fieldReader, objectWriter, fieldWriter, fieldName, nameSegment.nameHashCode);
        }
        return segment;
    }

    public static class NameSegmentTyped
    extends JSONPathSegmentName {
        final Class objectClass;
        final FieldReader fieldReader;
        final FieldWriter fieldWriter;

        public NameSegmentTyped(Class objectClass, ObjectReader objectReader, FieldReader fieldReader, ObjectWriter objectWriter, FieldWriter fieldWriter, String name, long nameHashCode) {
            super(name, nameHashCode);
            this.objectClass = objectClass;
            this.fieldReader = fieldReader;
            this.fieldWriter = fieldWriter;
        }

        @Override
        public void eval(JSONPath.Context context) {
            Object object;
            if (this.fieldWriter == null) {
                throw new UnsupportedOperationException();
            }
            Object object2 = object = context.parent == null ? context.root : context.parent.value;
            if (object == null) {
                return;
            }
            context.value = this.fieldWriter.getFieldValue(object);
        }
    }

    public static class TwoNameSegmentTypedPath
    extends JSONPathTwoSegment {
        final NameSegmentTyped first;
        final NameSegmentTyped second;

        public TwoNameSegmentTypedPath(String path, NameSegmentTyped first, NameSegmentTyped second) {
            super(path, first, second, new JSONPath.Feature[0]);
            this.first = first;
            this.second = second;
        }

        @Override
        public Object eval(Object root) {
            Object firstValue = this.first.fieldWriter.getFieldValue(root);
            if (firstValue == null) {
                return null;
            }
            return this.second.fieldWriter.getFieldValue(firstValue);
        }

        @Override
        public void set(Object root, Object value2) {
            Object firstValue = this.first.fieldWriter.getFieldValue(root);
            if (firstValue == null) {
                return;
            }
            this.second.fieldReader.accept(firstValue, value2);
        }

        @Override
        public void setInt(Object root, int value2) {
            Object firstValue = this.first.fieldWriter.getFieldValue(root);
            if (firstValue == null) {
                return;
            }
            this.second.fieldReader.accept(firstValue, value2);
        }

        @Override
        public void setLong(Object root, long value2) {
            Object firstValue = this.first.fieldWriter.getFieldValue(root);
            if (firstValue == null) {
                return;
            }
            this.second.fieldReader.accept(firstValue, value2);
        }

        @Override
        public void setCallback(Object root, BiFunction callback) {
            Object firstValue = this.first.fieldWriter.getFieldValue(root);
            if (firstValue == null) {
                return;
            }
            Object secondValue = this.second.fieldWriter.getFieldValue(firstValue);
            Object secondValueApply = callback.apply(firstValue, secondValue);
            if (secondValueApply == secondValue) {
                return;
            }
            if (this.second.fieldReader == null) {
                throw new UnsupportedOperationException();
            }
            this.second.fieldReader.accept(firstValue, secondValueApply);
        }
    }

    public static class SingleNamePathTyped
    extends JSONPath {
        final Class objectClass;
        final ObjectReader objectReader;
        final FieldReader fieldReader;
        final ObjectWriter objectWriter;
        final FieldWriter fieldWriter;

        public SingleNamePathTyped(String path, Class objectClass, ObjectReader objectReader, FieldReader fieldReader, ObjectWriter objectWriter, FieldWriter fieldWriter) {
            super(path, new JSONPath.Feature[0]);
            this.objectClass = objectClass;
            this.objectReader = objectReader;
            this.fieldReader = fieldReader;
            this.objectWriter = objectWriter;
            this.fieldWriter = fieldWriter;
        }

        @Override
        public JSONPath getParent() {
            return null;
        }

        @Override
        public boolean isRef() {
            return true;
        }

        @Override
        public boolean contains(Object rootObject) {
            return this.fieldWriter != null && this.fieldWriter.getFieldValue(rootObject) != null;
        }

        @Override
        public Object eval(Object object) {
            if (this.fieldWriter == null) {
                throw new UnsupportedOperationException();
            }
            return this.fieldWriter.getFieldValue(object);
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Object rootObject, Object value2) {
            if (this.fieldReader == null) {
                throw new UnsupportedOperationException();
            }
            this.fieldReader.accept(rootObject, value2);
        }

        @Override
        public void set(Object rootObject, Object value2, JSONReader.Feature ... readerFeatures) {
            if (this.fieldReader == null) {
                throw new UnsupportedOperationException();
            }
            this.fieldReader.accept(rootObject, value2);
        }

        @Override
        public void setCallback(Object rootObject, BiFunction callback) {
            if (this.fieldWriter == null) {
                throw new UnsupportedOperationException();
            }
            Object fieldValue = this.fieldWriter.getFieldValue(rootObject);
            Object fieldValueApply = callback.apply(rootObject, fieldValue);
            if (fieldValueApply == fieldValue) {
                return;
            }
            if (this.fieldReader == null) {
                throw new UnsupportedOperationException();
            }
            this.fieldReader.accept(rootObject, fieldValueApply);
        }

        @Override
        public void setInt(Object rootObject, int value2) {
            if (this.fieldReader == null) {
                throw new UnsupportedOperationException();
            }
            this.fieldReader.accept(rootObject, value2);
        }

        @Override
        public void setLong(Object rootObject, long value2) {
            if (this.fieldReader == null) {
                throw new UnsupportedOperationException();
            }
            this.fieldReader.accept(rootObject, value2);
        }

        @Override
        public boolean remove(Object rootObject) {
            throw new UnsupportedOperationException();
        }
    }
}

