/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriterInt64;
import java.lang.reflect.Field;

final class FieldWriterInt64ValField<T>
extends FieldWriterInt64<T> {
    FieldWriterInt64ValField(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, Long.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        return this.getFieldLong(object);
    }

    public long getFieldLong(T object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            long value2 = this.fieldOffset != -1L ? JDKUtils.UNSAFE.getLong(object, this.fieldOffset) : this.field.getLong(object);
            return value2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T o) {
        long value2 = this.getFieldLong(o);
        if (value2 == 0L && jsonWriter.isEnabled(JSONWriter.Feature.NotWriteDefaultValue)) {
            return false;
        }
        this.writeInt64(jsonWriter, value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        long value2 = this.getFieldLong(object);
        jsonWriter.writeInt64(value2);
    }
}

