/*
 * Decompiled with CFR 0.152.
 */
package com.integration.oauth2.sdk.method;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.integration.oauth2.sdk.OAuth2Client;
import com.integration.oauth2.sdk.OAuth2Exception;
import com.integration.oauth2.sdk.model.Org;
import com.integration.oauth2.sdk.model.Role;
import com.integration.oauth2.sdk.model.UserDetail;
import com.integration.oauth2.sdk.model.UserInfo;
import com.integration.oauth2.sdk.response.AccessTokenResponse;
import com.integration.oauth2.sdk.response.CommonResult;
import com.integration.oauth2.sdk.response.RefreshTokenResponse;
import java.util.List;

public class OAuth2ToMethod {
    public static AccessTokenResponse getAccessTokenWithCode(String code, String redirectUri) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            return OAuth2Method.oauth2Client.getAccessToken(code, redirectUri);
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getOpenApiToken(String account) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            return OAuth2Method.oauth2Client.getOpenApiToken(account);
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RefreshTokenResponse getRefreshTokenWithCode(String refreshToken) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            return OAuth2Method.oauth2Client.refreshToken(refreshToken);
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static UserDetail getUserDetail(String accessToken, String account) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.getUserDetail(accessToken, account);
            ObjectMapper objectMapperU = new ObjectMapper();
            objectMapperU.registerModule(new JavaTimeModule());
            objectMapperU.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            try {
                JSONObject jsonObject = new JSONObject(json);
                boolean jsonObjectState = (Boolean)jsonObject.get("state");
                if (jsonObjectState) {
                    JSONObject jsonList = (JSONObject)jsonObject.get("value");
                    json = jsonList.toString();
                }
                UserDetail userDetail = objectMapperU.readValue(json, UserDetail.class);
                return userDetail;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static UserInfo getUserInfo(String accessToken) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.getUserInfo(accessToken);
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JSONObject jsonObject = new JSONObject(json);
                boolean jsonObjectState = (Boolean)jsonObject.get("state");
                if (jsonObjectState) {
                    JSONObject jsonList = (JSONObject)jsonObject.get("value");
                    json = jsonList.toString();
                }
                UserInfo userInfos = objectMapper.readValue(json, UserInfo.class);
                return userInfos;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static List<Org> getOrgsAll(String apiToken, String updateTime) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.getOrgsAll(apiToken, updateTime);
            System.out.println(json);
            JSONObject jsonObject = new JSONObject(json);
            boolean jsonObjectState = (Boolean)jsonObject.get("state");
            if (jsonObjectState) {
                JSONObject jsonList = (JSONObject)jsonObject.get("value");
                JSONArray jsonArray = (JSONArray)jsonList.get("rows");
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.registerModule(new JavaTimeModule());
                String jsonString = jsonArray.toString();
                try {
                    List<Org> orgList = objectMapper.readValue(jsonString, new TypeReference<List<Org>>(){});
                    return orgList;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(jsonObject.get("message").toString());
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<UserDetail> getUsersAll(String apiToken, String pageNum, String pageSize) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.getUsersAll(apiToken, pageNum, pageSize);
            System.out.println("json: " + json);
            JSONObject jsonObject = new JSONObject(json);
            boolean jsonObjectState = (Boolean)jsonObject.get("state");
            if (jsonObjectState) {
                JSONObject jsonList = (JSONObject)jsonObject.get("value");
                JSONArray jsonArray = (JSONArray)jsonList.get("rows");
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.registerModule(new JavaTimeModule());
                String jsonString = jsonArray.toString();
                try {
                    List<UserDetail> userList = objectMapper.readValue(jsonString, new TypeReference<List<UserDetail>>(){});
                    return userList;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(jsonObject.get("message").toString());
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult updateUserPwd(String apiToken, String id, String password) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.updateUserPwd(apiToken, id, password);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult updateUser(String apiToken, String fullName, String account, String mobile, String status) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.updateUser(apiToken, fullName, account, mobile, status);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult restUserPwd(String apiToken, String account, String password) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.restUserPwd(apiToken, account, password);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult deleteUser(String apiToken, String account) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.deleteUser(apiToken, account);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult changePwd(String apiToken, String account, String oldPwd, String newPwd) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.changePwd(apiToken, account, oldPwd, newPwd);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult userRegister(String apiToken, String fullName, String account, String mobile, String password) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.userRegister(apiToken, fullName, account, mobile, password);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Role> getRolesAll(String apiToken, String pageNum, String pageSize) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.getRolesAll(apiToken, pageNum, pageSize);
            JSONObject jsonObject = new JSONObject(json);
            boolean jsonObjectState = (Boolean)jsonObject.get("state");
            if (jsonObjectState) {
                JSONObject jsonList = (JSONObject)jsonObject.get("value");
                JSONArray jsonArray = (JSONArray)jsonList.get("rows");
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.registerModule(new JavaTimeModule());
                String jsonString = jsonArray.toString();
                try {
                    List<Role> userList = objectMapper.readValue(jsonString, new TypeReference<List<Role>>(){});
                    return userList;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(jsonObject.get("message").toString());
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult sendMsg(String apiToken, String subject, String description, String content, String receiverId) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.sendMsg(apiToken, subject, description, content, receiverId);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult sendMsg(String apiToken, String subject, String description, String content, String receiverId, String messageNewType) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.sendMsg(apiToken, subject, description, content, receiverId, messageNewType);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult getMsgStatus(String apiToken, String message_id) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.getMsgStatus(apiToken, message_id);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CommonResult deleteMsg(String apiToken, String message_id) {
        try {
            if (OAuth2Method.getOauth2Client() == null) {
                throw new IllegalStateException("OAuth2Client \u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528 initClient \u65b9\u6cd5");
            }
            String json = OAuth2Method.oauth2Client.deleteMsg(apiToken, message_id);
            JSONObject jsonObject = new JSONObject(json);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule(new JavaTimeModule());
            CommonResult commonResult = null;
            try {
                commonResult = objectMapper.readValue(jsonObject.toString(), CommonResult.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return commonResult;
        }
        catch (OAuth2Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class OAuth2Method {
        private static OAuth2Client oauth2Client;

        public static OAuth2Client initClient(String baseUrl, String clientId, String clientSecret, String publicKey, int timeOut) {
            if (oauth2Client == null) {
                oauth2Client = OAuth2Client.getInstance(baseUrl, clientId, clientSecret, publicKey);
                oauth2Client.setTimeout(timeOut);
            }
            return oauth2Client;
        }

        public static OAuth2Client getOauth2Client() {
            return oauth2Client;
        }
    }
}

