/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ByteUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

public class NumberConverter
extends AbstractConverter<Number> {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }

    @Override
    protected Number convertInternal(Object value2) {
        return NumberConverter.convert(value2, this.targetType, this::convertToStr);
    }

    @Override
    protected String convertToStr(Object value2) {
        char c;
        String result = StrUtil.trim(super.convertToStr(value2));
        if (StrUtil.isNotEmpty(result) && ((c = Character.toUpperCase(result.charAt(result.length() - 1))) == 'D' || c == 'L' || c == 'F')) {
            return StrUtil.subPre(result, -1);
        }
        return result;
    }

    protected static Number convert(Object value2, Class<? extends Number> targetType, Function<Object, String> toStrFunc) {
        if (value2 instanceof Enum) {
            return NumberConverter.convert(((Enum)value2).ordinal(), targetType, toStrFunc);
        }
        if (value2 instanceof byte[]) {
            return ByteUtil.bytesToNumber((byte[])value2, targetType, ByteUtil.DEFAULT_ORDER);
        }
        if (Byte.class == targetType) {
            if (value2 instanceof Number) {
                return ((Number)value2).byteValue();
            }
            if (value2 instanceof Boolean) {
                return BooleanUtil.toByteObj((Boolean)value2);
            }
            String valueStr = toStrFunc.apply(value2);
            try {
                return StrUtil.isBlank(valueStr) ? null : Byte.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return NumberUtil.parseNumber(valueStr).byteValue();
            }
        }
        if (Short.class == targetType) {
            if (value2 instanceof Number) {
                return ((Number)value2).shortValue();
            }
            if (value2 instanceof Boolean) {
                return BooleanUtil.toShortObj((Boolean)value2);
            }
            String valueStr = toStrFunc.apply(value2);
            try {
                return StrUtil.isBlank(valueStr) ? null : Short.valueOf(valueStr);
            }
            catch (NumberFormatException e) {
                return NumberUtil.parseNumber(valueStr).shortValue();
            }
        }
        if (Integer.class == targetType) {
            if (value2 instanceof Number) {
                return ((Number)value2).intValue();
            }
            if (value2 instanceof Boolean) {
                return BooleanUtil.toInteger((Boolean)value2);
            }
            if (value2 instanceof Date) {
                return (int)((Date)value2).getTime();
            }
            if (value2 instanceof Calendar) {
                return (int)((Calendar)value2).getTimeInMillis();
            }
            if (value2 instanceof TemporalAccessor) {
                return (int)DateUtil.toInstant((TemporalAccessor)value2).toEpochMilli();
            }
            String valueStr = toStrFunc.apply(value2);
            return StrUtil.isBlank(valueStr) ? null : Integer.valueOf(NumberUtil.parseInt(valueStr));
        }
        if (AtomicInteger.class == targetType) {
            Number number = NumberConverter.convert(value2, Integer.class, toStrFunc);
            if (null != number) {
                return new AtomicInteger(number.intValue());
            }
        } else {
            if (Long.class == targetType) {
                if (value2 instanceof Number) {
                    return ((Number)value2).longValue();
                }
                if (value2 instanceof Boolean) {
                    return BooleanUtil.toLongObj((Boolean)value2);
                }
                if (value2 instanceof Date) {
                    return ((Date)value2).getTime();
                }
                if (value2 instanceof Calendar) {
                    return ((Calendar)value2).getTimeInMillis();
                }
                if (value2 instanceof TemporalAccessor) {
                    return DateUtil.toInstant((TemporalAccessor)value2).toEpochMilli();
                }
                String valueStr = toStrFunc.apply(value2);
                return StrUtil.isBlank(valueStr) ? null : Long.valueOf(NumberUtil.parseLong(valueStr));
            }
            if (AtomicLong.class == targetType) {
                Number number = NumberConverter.convert(value2, Long.class, toStrFunc);
                if (null != number) {
                    return new AtomicLong(number.longValue());
                }
            } else if (LongAdder.class == targetType) {
                Number number = NumberConverter.convert(value2, Long.class, toStrFunc);
                if (null != number) {
                    LongAdder longValue = new LongAdder();
                    longValue.add(number.longValue());
                    return longValue;
                }
            } else {
                if (Float.class == targetType) {
                    if (value2 instanceof Number) {
                        return Float.valueOf(((Number)value2).floatValue());
                    }
                    if (value2 instanceof Boolean) {
                        return BooleanUtil.toFloatObj((Boolean)value2);
                    }
                    String valueStr = toStrFunc.apply(value2);
                    return StrUtil.isBlank(valueStr) ? null : Float.valueOf(NumberUtil.parseFloat(valueStr));
                }
                if (Double.class == targetType) {
                    if (value2 instanceof Number) {
                        return ((Number)value2).doubleValue();
                    }
                    if (value2 instanceof Boolean) {
                        return BooleanUtil.toDoubleObj((Boolean)value2);
                    }
                    String valueStr = toStrFunc.apply(value2);
                    return StrUtil.isBlank(valueStr) ? null : Double.valueOf(NumberUtil.parseDouble(valueStr));
                }
                if (DoubleAdder.class == targetType) {
                    Number number = NumberConverter.convert(value2, Long.class, toStrFunc);
                    if (null != number) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(number.doubleValue());
                        return doubleAdder;
                    }
                } else {
                    if (BigDecimal.class == targetType) {
                        return NumberConverter.toBigDecimal(value2, toStrFunc);
                    }
                    if (BigInteger.class == targetType) {
                        return NumberConverter.toBigInteger(value2, toStrFunc);
                    }
                    if (Number.class == targetType) {
                        if (value2 instanceof Number) {
                            return (Number)value2;
                        }
                        if (value2 instanceof Boolean) {
                            return BooleanUtil.toInteger((Boolean)value2);
                        }
                        String valueStr = toStrFunc.apply(value2);
                        return StrUtil.isBlank(valueStr) ? (Number)null : (Number)NumberUtil.parseNumber(valueStr);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupport Number type: {}", targetType.getName()));
    }

    private static BigDecimal toBigDecimal(Object value2, Function<Object, String> toStrFunc) {
        if (value2 instanceof Number) {
            return NumberUtil.toBigDecimal((Number)value2);
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2 != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        return NumberUtil.toBigDecimal(toStrFunc.apply(value2));
    }

    private static BigInteger toBigInteger(Object value2, Function<Object, String> toStrFunc) {
        if (value2 instanceof Long) {
            return BigInteger.valueOf((Long)value2);
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2 != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        return NumberUtil.toBigInteger(toStrFunc.apply(value2));
    }
}

