/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.stream;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.stream.JSONStreamReaderUTF16;
import com.alibaba.fastjson2.stream.JSONStreamReaderUTF8;
import com.alibaba.fastjson2.stream.StreamReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class JSONStreamReader<T>
extends StreamReader<T> {
    protected ObjectReaderAdapter objectReader;

    public JSONStreamReader(Type[] types) {
        super(types);
    }

    public JSONStreamReader(ObjectReaderAdapter objectReader) {
        this.objectReader = objectReader;
    }

    public static JSONStreamReader of(File file) throws IOException {
        return JSONStreamReader.of(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8, new Type[0]);
    }

    public static JSONStreamReader of(InputStream in) throws IOException {
        return JSONStreamReader.of(in, StandardCharsets.UTF_8, new Type[0]);
    }

    public static JSONStreamReader of(InputStream in, Type ... types) throws IOException {
        return JSONStreamReader.of(in, StandardCharsets.UTF_8, types);
    }

    public static JSONStreamReader of(InputStream in, Charset charset, Type ... types) {
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new JSONStreamReaderUTF16((Reader)new InputStreamReader(in, charset), types);
        }
        return new JSONStreamReaderUTF8(in, charset, types);
    }

    public static JSONStreamReader of(InputStream in, Class objectClass) {
        return JSONStreamReader.of(in, StandardCharsets.UTF_8, objectClass);
    }

    public static JSONStreamReader of(InputStream in, Charset charset, Class objectClass) {
        JSONReader.Context context = JSONFactory.createReadContext();
        ObjectReaderAdapter objectReader = (ObjectReaderAdapter)context.getObjectReader(objectClass);
        if (charset == StandardCharsets.UTF_16 || charset == StandardCharsets.UTF_16LE || charset == StandardCharsets.UTF_16BE) {
            return new JSONStreamReaderUTF16((Reader)new InputStreamReader(in, charset), objectReader);
        }
        return new JSONStreamReaderUTF8(in, charset, objectReader);
    }

    public StreamReader.ColumnStat getColumnStat(String name) {
        StreamReader.ColumnStat stat;
        if (this.columnStatsMap == null) {
            this.columnStatsMap = new LinkedHashMap();
        }
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        if (this.columnStats == null) {
            this.columnStats = new ArrayList();
        }
        if ((stat = (StreamReader.ColumnStat)this.columnStatsMap.get(name)) == null && this.columnStatsMap.size() <= 100) {
            stat = new StreamReader.ColumnStat(name);
            this.columnStatsMap.put(name, stat);
            this.columns.add(name);
            this.columnStats.add(stat);
        }
        return stat;
    }

    protected static void stat(StreamReader.ColumnStat stat, Object value2) {
        if (stat == null) {
            return;
        }
        if (value2 == null) {
            ++stat.nulls;
            return;
        }
        ++stat.values;
        if (value2 instanceof Number) {
            ++stat.numbers;
            if (value2 instanceof Byte || value2 instanceof Short || value2 instanceof Integer || value2 instanceof Long) {
                ++stat.integers;
            } else if (value2 instanceof Float || value2 instanceof Double) {
                ++stat.doubles;
            }
            return;
        }
        if (value2 instanceof String) {
            stat.stat((String)value2);
            return;
        }
        if (value2 instanceof Boolean) {
            ++stat.booleans;
            return;
        }
        if (value2 instanceof Map) {
            ++stat.maps;
            return;
        }
        if (value2 instanceof Collection) {
            ++stat.arrays;
        }
    }

    public void statAll() {
        Object object;
        this.columnStatsMap = new LinkedHashMap();
        this.columns = new ArrayList();
        this.columnStats = new ArrayList();
        while ((object = this.readLineObject()) != null) {
            this.statLine(object);
        }
    }

    public void statLine(Object object) {
        if (object instanceof Map) {
            this.statMap(null, (Map)object, 0);
        } else if (object instanceof List) {
            this.statArray(null, (List)object, 0);
        }
        ++this.rowCount;
    }

    private void statArray(String parentKey, List list, int level) {
        if (level > 10) {
            return;
        }
        if (list.size() > 10) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.get(i);
            String strKey = parentKey == null ? "[" + i + "]" : parentKey + "[" + i + "]";
            StreamReader.ColumnStat stat = this.getColumnStat(parentKey);
            JSONStreamReader.stat(stat, item);
            if (item instanceof Map) {
                this.statMap(strKey, (Map)item, level + 1);
                continue;
            }
            if (!(item instanceof List)) continue;
            this.statArray(strKey, (List)item, level + 1);
        }
    }

    private void statMap(String parentKey, Map map, int level) {
        if (level > 10) {
            return;
        }
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = o;
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            String strKey = parentKey == null ? (String)key : parentKey + "." + key;
            StreamReader.ColumnStat stat = this.getColumnStat(strKey);
            Object entryValue = entry.getValue();
            JSONStreamReader.stat(stat, entryValue);
            if (entryValue instanceof Map) {
                this.statMap(strKey, (Map)entryValue, level + 1);
                continue;
            }
            if (!(entryValue instanceof List)) continue;
            this.statArray(strKey, (List)entryValue, level + 1);
        }
    }
}

