/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterList;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;

final class FieldWriterListField<T>
extends FieldWriterList<T> {
    FieldWriterListField(String fieldName, Type itemType, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field) {
        super(fieldName, itemType, ordinal, features, format, label, fieldType, fieldClass, field, null);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        List value2 = (List)this.getFieldValue(object);
        JSONWriter.Context context = jsonWriter.context;
        if (value2 == null) {
            long features = this.features | context.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeArrayNull();
                return true;
            }
            return false;
        }
        String refPath = jsonWriter.setPath(this, (Object)value2);
        if (refPath != null) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeReference(refPath);
            jsonWriter.popPath(value2);
            return true;
        }
        if (this.itemType == String.class) {
            this.writeListStr(jsonWriter, true, value2);
        } else {
            this.writeList(jsonWriter, value2);
        }
        jsonWriter.popPath(value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String refPath;
        List value2 = (List)this.getFieldValue(object);
        if (value2 == null) {
            jsonWriter.writeNull();
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        if (refDetect && (refPath = jsonWriter.setPath(this.fieldName, (Object)value2)) != null) {
            jsonWriter.writeReference(refPath);
            jsonWriter.popPath(value2);
            return;
        }
        this.writeListValue(jsonWriter, value2);
        if (refDetect) {
            jsonWriter.popPath(value2);
        }
    }
}

