/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.JodaSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterArrayFinal;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplCalendar;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplInstant;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptional;
import com.alibaba.fastjson2.writer.ObjectWriterImplZonedDateTime;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.zip.GZIPOutputStream;

public abstract class FieldWriter<T>
implements Comparable {
    public final String fieldName;
    public final Type fieldType;
    public final Class fieldClass;
    public final long features;
    public final int ordinal;
    public final String format;
    public final DecimalFormat decimalFormat;
    public final String label;
    public final Field field;
    public final Method method;
    protected final long fieldOffset;
    protected final boolean primitive;
    final long hashCode;
    final byte[] nameWithColonUTF8;
    final char[] nameWithColonUTF16;
    final byte[] nameJSONB;
    long nameSymbolCache;
    final boolean fieldClassSerializable;
    final JSONWriter.Path rootParentPath;
    final boolean symbol;
    final boolean trim;
    final boolean raw;
    transient JSONWriter.Path path;
    volatile ObjectWriter initObjectWriter;
    Object defaultValue;
    static final AtomicReferenceFieldUpdater<FieldWriter, ObjectWriter> initObjectWriterUpdater = AtomicReferenceFieldUpdater.newUpdater(FieldWriter.class, ObjectWriter.class, "initObjectWriter");

    FieldWriter(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        if ("string".equals(format) && fieldClass != String.class) {
            features |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
        }
        this.fieldName = name;
        this.ordinal = ordinal;
        this.format = format;
        this.label = label;
        this.hashCode = Fnv.hashCode64(name);
        this.features = features;
        this.fieldType = TypeUtils.intern(fieldType);
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && (Serializable.class.isAssignableFrom(fieldClass) || !Modifier.isFinal(fieldClass.getModifiers()));
        this.field = field;
        this.method = method;
        this.primitive = fieldClass.isPrimitive();
        this.nameJSONB = JSONB.toBytes(this.fieldName);
        DecimalFormat decimalFormat = null;
        if (format != null && (fieldClass == Float.TYPE || fieldClass == float[].class || fieldClass == Float.class || fieldClass == Float[].class || fieldClass == Double.TYPE || fieldClass == double[].class || fieldClass == Double.class || fieldClass == Double[].class || fieldClass == BigDecimal.class || fieldClass == BigDecimal[].class)) {
            decimalFormat = new DecimalFormat(format);
        }
        this.decimalFormat = decimalFormat;
        long fieldOffset = -1L;
        if (field != null) {
            fieldOffset = JDKUtils.UNSAFE.objectFieldOffset(field);
        }
        this.fieldOffset = fieldOffset;
        this.symbol = "symbol".equals(format);
        this.trim = "trim".equals(format);
        this.raw = (features & 0x4000000000000L) != 0L;
        this.rootParentPath = new JSONWriter.Path(JSONWriter.Path.ROOT, name);
        int nameLength = name.length();
        int utflen = nameLength + 3;
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        byte[] bytes = new byte[utflen];
        int off = 0;
        bytes[off++] = 34;
        for (int i = 0; i < nameLength; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[off++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytes[off++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[off++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[off++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            bytes[off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytes[off++] = (byte)(0x80 | c & 0x3F);
        }
        bytes[off++] = 34;
        bytes[off] = 58;
        this.nameWithColonUTF8 = bytes;
        char[] chars = new char[nameLength + 3];
        chars[0] = 34;
        name.getChars(0, name.length(), chars, 1);
        chars[chars.length - 2] = 34;
        chars[chars.length - 1] = 58;
        this.nameWithColonUTF16 = chars;
    }

    public boolean isFieldClassSerializable() {
        return this.fieldClassSerializable;
    }

    public boolean isDateFormatMillis() {
        return false;
    }

    public boolean isDateFormatISO8601() {
        return false;
    }

    public void writeEnumJSONB(JSONWriter jsonWriter, Enum e) {
        throw new UnsupportedOperationException();
    }

    public ObjectWriter getInitWriter() {
        return null;
    }

    public boolean unwrapped() {
        return false;
    }

    public final void writeFieldNameJSONB(JSONWriter jsonWriter) {
        SymbolTable symbolTable = jsonWriter.symbolTable;
        if (symbolTable != null && this.writeFieldNameSymbol(jsonWriter, symbolTable)) {
            return;
        }
        jsonWriter.writeNameRaw(this.nameJSONB, this.hashCode);
    }

    public final void writeFieldName(JSONWriter jsonWriter) {
        if (jsonWriter.jsonb) {
            SymbolTable symbolTable = jsonWriter.symbolTable;
            if (symbolTable != null && this.writeFieldNameSymbol(jsonWriter, symbolTable)) {
                return;
            }
            jsonWriter.writeNameRaw(this.nameJSONB, this.hashCode);
            return;
        }
        if (!jsonWriter.useSingleQuote && (jsonWriter.context.getFeatures() & JSONWriter.Feature.UnquoteFieldName.mask) == 0L) {
            if (jsonWriter.utf8) {
                jsonWriter.writeNameRaw(this.nameWithColonUTF8);
                return;
            }
            if (jsonWriter.utf16) {
                jsonWriter.writeNameRaw(this.nameWithColonUTF16);
                return;
            }
        }
        jsonWriter.writeName(this.fieldName);
        jsonWriter.writeColon();
    }

    private boolean writeFieldNameSymbol(JSONWriter jsonWriter, SymbolTable symbolTable) {
        int symbol;
        int symbolTableIdentity = System.identityHashCode(symbolTable);
        if (this.nameSymbolCache == 0L) {
            symbol = symbolTable.getOrdinalByHashCode(this.hashCode);
            this.nameSymbolCache = (long)symbol << 32 | (long)symbolTableIdentity;
        } else if ((int)this.nameSymbolCache == symbolTableIdentity) {
            symbol = (int)(this.nameSymbolCache >> 32);
        } else {
            symbol = symbolTable.getOrdinalByHashCode(this.hashCode);
            this.nameSymbolCache = (long)symbol << 32 | (long)symbolTableIdentity;
        }
        if (symbol != -1) {
            jsonWriter.writeSymbol(-symbol);
            return true;
        }
        return false;
    }

    public final JSONWriter.Path getRootParentPath() {
        return this.rootParentPath;
    }

    public final JSONWriter.Path getPath(JSONWriter.Path parent) {
        if (this.path == null) {
            this.path = new JSONWriter.Path(parent, this.fieldName);
            return this.path;
        }
        if (this.path.parent == parent) {
            return this.path;
        }
        return new JSONWriter.Path(parent, this.fieldName);
    }

    public Type getItemType() {
        return null;
    }

    public Class getItemClass() {
        return null;
    }

    public String toString() {
        return this.fieldName;
    }

    void setDefaultValue(T object) {
        Object fieldValue = null;
        if (Iterable.class.isAssignableFrom(this.fieldClass) || Map.class.isAssignableFrom(this.fieldClass)) {
            return;
        }
        if (this.field != null && object != null) {
            try {
                this.field.setAccessible(true);
                fieldValue = this.field.get(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (fieldValue == null) {
            return;
        }
        if (this.fieldClass == Boolean.TYPE ? fieldValue == Boolean.FALSE : (this.fieldClass == Byte.TYPE || this.fieldClass == Short.TYPE || this.fieldClass == Integer.TYPE || this.fieldClass == Long.TYPE || this.fieldClass == Float.TYPE || this.fieldClass == Double.TYPE ? ((Number)fieldValue).doubleValue() == 0.0 : this.fieldClass == Character.TYPE && ((Character)fieldValue).charValue() == '\u0000')) {
            return;
        }
        this.defaultValue = fieldValue;
    }

    public Object getFieldValue(T object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        if (this.field != null) {
            try {
                Object value2 = this.fieldOffset != -1L && !this.primitive ? JDKUtils.UNSAFE.getObject(object, this.fieldOffset) : this.field.get(object);
                return value2;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new JSONException("field.get error, " + this.fieldName, e);
            }
        }
        throw new UnsupportedOperationException();
    }

    public int compareTo(Object o) {
        String otherMethodName;
        String thisMethodName;
        FieldWriter other = (FieldWriter)o;
        int thisOrdinal = this.ordinal;
        int otherOrdinal = other.ordinal;
        if (thisOrdinal < otherOrdinal) {
            return -1;
        }
        if (thisOrdinal > otherOrdinal) {
            return 1;
        }
        int nameCompare = this.fieldName.compareTo(other.fieldName);
        if (nameCompare != 0) {
            return nameCompare;
        }
        AccessibleObject thisMember = this.method == null || this.field != null && Modifier.isPublic(this.field.getModifiers()) ? this.field : this.method;
        AccessibleObject otherMember = other.method == null || other.field != null && Modifier.isPublic(other.field.getModifiers()) ? other.field : other.method;
        if (thisMember != null && otherMember != null) {
            Class<?> otherDeclaringClass = otherMember.getDeclaringClass();
            Class<?> thisDeclaringClass = thisMember.getDeclaringClass();
            if (thisDeclaringClass != otherDeclaringClass) {
                if (thisDeclaringClass.isAssignableFrom(otherDeclaringClass)) {
                    return 1;
                }
                if (otherDeclaringClass.isAssignableFrom(thisDeclaringClass)) {
                    return -1;
                }
            }
            JSONField thisField = null;
            JSONField otherField = null;
            if (thisMember instanceof Field) {
                thisField = ((Field)thisMember).getAnnotation(JSONField.class);
            } else if (thisMember instanceof Method) {
                thisField = ((Method)thisMember).getAnnotation(JSONField.class);
            }
            if (otherMember instanceof Field) {
                otherField = ((Field)otherMember).getAnnotation(JSONField.class);
            } else if (thisMember instanceof Method) {
                otherField = ((Method)otherMember).getAnnotation(JSONField.class);
            }
            if (thisField != null && otherField == null) {
                return -1;
            }
            if (thisField == null && otherField != null) {
                return 1;
            }
        }
        if (thisMember instanceof Field && otherMember instanceof Method && ((Field)thisMember).getType() == ((Method)otherMember).getReturnType()) {
            return -1;
        }
        if (thisMember instanceof Method && otherMember instanceof Field && ((Method)thisMember).getReturnType() == ((Field)otherMember).getType()) {
            return 1;
        }
        Class thisFieldClass = this.fieldClass;
        Class otherFieldClass = other.fieldClass;
        if (thisFieldClass != otherFieldClass && thisFieldClass != null && otherFieldClass != null) {
            if (thisFieldClass.isAssignableFrom(otherFieldClass)) {
                return 1;
            }
            if (otherFieldClass.isAssignableFrom(thisFieldClass)) {
                return -1;
            }
        }
        if (thisFieldClass == Boolean.TYPE && otherFieldClass != Boolean.TYPE) {
            return 1;
        }
        if (thisFieldClass == Boolean.class && otherFieldClass == Boolean.class && thisMember instanceof Method && otherMember instanceof Method) {
            thisMethodName = thisMember.getName();
            otherMethodName = otherMember.getName();
            if (thisMethodName.startsWith("is") && otherMethodName.startsWith("get")) {
                return 1;
            }
            if (thisMethodName.startsWith("get") && otherMethodName.startsWith("is")) {
                return -1;
            }
        }
        if (thisMember instanceof Method && otherMember instanceof Method && !(thisMethodName = thisMember.getName()).equals(otherMethodName = otherMember.getName())) {
            String thisSetterName = BeanUtils.getterName(thisMethodName, null);
            String otherSetterName = BeanUtils.getterName(otherMethodName, null);
            if (this.fieldName.equals(thisSetterName) && !other.fieldName.equals(otherSetterName)) {
                return 1;
            }
            if (this.fieldName.equals(otherSetterName) && !other.fieldName.equals(thisSetterName)) {
                return -1;
            }
        }
        if (thisFieldClass.isPrimitive() && !otherFieldClass.isPrimitive()) {
            return -1;
        }
        if (!thisFieldClass.isPrimitive() && otherFieldClass.isPrimitive()) {
            return 1;
        }
        if (thisFieldClass.getName().startsWith("java.") && !otherFieldClass.getName().startsWith("java.")) {
            return -1;
        }
        if (!thisFieldClass.getName().startsWith("java.") && otherFieldClass.getName().startsWith("java.")) {
            return 1;
        }
        return nameCompare;
    }

    public void writeEnum(JSONWriter jsonWriter, Enum e) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeEnum(e);
    }

    public void writeBinary(JSONWriter jsonWriter, byte[] value2) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (value2 == null) {
                            if (!jsonWriter.isWriteNulls()) {
                                return;
                            }
                            this.writeFieldName(jsonWriter);
                            jsonWriter.writeArrayNull();
                            return;
                        }
                        this.writeFieldName(jsonWriter);
                        if (!"base64".equals(this.format) && (this.format != null || (jsonWriter.getFeatures(this.features) & JSONWriter.Feature.WriteByteArrayAsBase64.mask) == 0L)) break block6;
                        jsonWriter.writeBase64(value2);
                        break block7;
                    }
                    if (!"hex".equals(this.format)) break block8;
                    jsonWriter.writeHex(value2);
                    break block7;
                }
                if (!"gzip,base64".equals(this.format) && !"gzip".equals(this.format)) break block9;
                GZIPOutputStream gzipOut = null;
                try {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    gzipOut = value2.length < 512 ? new GZIPOutputStream((OutputStream)byteOut, value2.length) : new GZIPOutputStream(byteOut);
                    gzipOut.write(value2);
                    gzipOut.finish();
                    value2 = byteOut.toByteArray();
                }
                catch (IOException ex) {
                    try {
                        throw new JSONException("write gzipBytes error", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(gzipOut);
                        throw throwable;
                    }
                }
                IOUtils.close(gzipOut);
                jsonWriter.writeBase64(value2);
                break block7;
            }
            jsonWriter.writeBinary(value2);
        }
    }

    public void writeInt16(JSONWriter jsonWriter, short[] value2) {
        if (value2 == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt16(value2);
    }

    public void writeInt32(JSONWriter jsonWriter, int value2) {
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt32(value2);
    }

    public void writeInt64(JSONWriter jsonWriter, long value2) {
        this.writeFieldName(jsonWriter);
        if ((this.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(Long.toString(value2));
        } else {
            jsonWriter.writeInt64(value2);
        }
    }

    public void writeString(JSONWriter jsonWriter, String value2) {
        this.writeFieldName(jsonWriter);
        if (value2 == null && (this.features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) != 0L) {
            jsonWriter.writeString("");
            return;
        }
        if (this.trim && value2 != null) {
            value2 = value2.trim();
        }
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value2);
        } else if (this.raw) {
            jsonWriter.writeRaw(value2);
        } else {
            jsonWriter.writeString(value2);
        }
    }

    public void writeString(JSONWriter jsonWriter, char[] value2) {
        if (value2 == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        if (value2 == null) {
            jsonWriter.writeStringNull();
            return;
        }
        jsonWriter.writeString(value2, 0, value2.length);
    }

    public void writeFloat(JSONWriter jsonWriter, float value2) {
        this.writeFieldName(jsonWriter);
        if (this.decimalFormat != null) {
            jsonWriter.writeFloat(value2, this.decimalFormat);
        } else {
            jsonWriter.writeFloat(value2);
        }
    }

    public void writeDouble(JSONWriter jsonWriter, double value2) {
        this.writeFieldName(jsonWriter);
        if (this.decimalFormat != null) {
            jsonWriter.writeDouble(value2, this.decimalFormat);
        } else {
            jsonWriter.writeDouble(value2);
        }
    }

    public void writeBool(JSONWriter jsonWriter, boolean value2) {
        throw new UnsupportedOperationException();
    }

    public void writeBool(JSONWriter jsonWriter, boolean[] value2) {
        if (value2 == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeBool(value2);
    }

    public void writeFloat(JSONWriter jsonWriter, float[] value2) {
        if (value2 == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeFloat(value2);
    }

    public void writeDouble(JSONWriter jsonWriter, double[] value2) {
        if (value2 == null && !jsonWriter.isWriteNulls()) {
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDouble(value2);
    }

    public void writeDouble(JSONWriter jsonWriter, Double value2) {
        if (value2 == null) {
            long features = jsonWriter.getFeatures(this.features);
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L && (features & JSONWriter.Feature.NotWriteDefaultValue.mask) == 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNumberNull();
            }
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDouble(value2);
    }

    public void writeDate(JSONWriter jsonWriter, boolean writeFieldName, Date value2) {
        if (value2 == null) {
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeNull();
            return;
        }
        this.writeDate(jsonWriter, writeFieldName, value2.getTime());
    }

    public void writeDate(JSONWriter jsonWriter, long millis) {
        this.writeDate(jsonWriter, true, millis);
    }

    public void writeDate(JSONWriter jsonWriter, boolean writeFieldName, long millis) {
        if (jsonWriter.jsonb) {
            jsonWriter.writeMillis(millis);
            return;
        }
        int SECONDS_PER_DAY = 86400;
        JSONWriter.Context ctx = jsonWriter.context;
        if (this.isDateFormatMillis() || ctx.isDateFormatMillis()) {
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeInt64(millis);
            return;
        }
        ZoneId zoneId = ctx.getZoneId();
        String dateFormat = ctx.getDateFormat();
        if (dateFormat == null) {
            long yearEst;
            long doyEst;
            Instant instant = Instant.ofEpochMilli(millis);
            long epochSecond = instant.getEpochSecond();
            ZoneOffset offset = zoneId.getRules().getOffset(instant);
            long localSecond = epochSecond + (long)offset.getTotalSeconds();
            long localEpochDay = Math.floorDiv(localSecond, 86400L);
            int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
            int DAYS_PER_CYCLE = 146097;
            long DAYS_0000_TO_1970 = 719528L;
            long zeroDay = localEpochDay + 719528L;
            long adjust = 0L;
            if ((zeroDay -= 60L) < 0L) {
                long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
                adjust = adjustCycles * 400L;
                zeroDay += -adjustCycles * 146097L;
            }
            if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
                doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
            }
            yearEst += adjust;
            int marchDoy0 = (int)doyEst;
            int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
            int month = (marchMonth0 + 2) % 12 + 1;
            int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
            int year = ChronoField.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
            int MINUTES_PER_HOUR = 60;
            int SECONDS_PER_MINUTE = 60;
            int SECONDS_PER_HOUR = 3600;
            long secondOfDay = secsOfDay;
            ChronoField.SECOND_OF_DAY.checkValidValue(secondOfDay);
            int hours = (int)(secondOfDay / 3600L);
            int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
            int hour = hours;
            int minute = minutes;
            int second = (int)(secondOfDay -= (long)(minutes * 60));
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
        } else {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
            if (this.isDateFormatISO8601() || ctx.isDateFormatISO8601()) {
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                int milliSeconds = zdt.getNano() / 1000000;
                int offsetSeconds = zdt.getOffset().getTotalSeconds();
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, milliSeconds, offsetSeconds, true);
                return;
            }
            String str = ctx.getDateFormatter().format(zdt);
            if (writeFieldName) {
                this.writeFieldName(jsonWriter);
            }
            jsonWriter.writeString(str);
        }
    }

    public ObjectWriter getItemWriter(JSONWriter writer, Type itemType) {
        return writer.getObjectWriter(itemType, null);
    }

    public abstract void writeValue(JSONWriter var1, T var2);

    public abstract boolean write(JSONWriter var1, T var2);

    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (valueClass == Float[].class) {
            if (this.decimalFormat != null) {
                return new ObjectWriterArrayFinal(Float.class, this.decimalFormat);
            }
            return ObjectWriterArrayFinal.FLOAT_ARRAY;
        }
        if (valueClass == Double[].class) {
            if (this.decimalFormat != null) {
                return new ObjectWriterArrayFinal(Double.class, this.decimalFormat);
            }
            return ObjectWriterArrayFinal.DOUBLE_ARRAY;
        }
        if (valueClass == BigDecimal[].class) {
            if (this.decimalFormat != null) {
                return new ObjectWriterArrayFinal(BigDecimal.class, this.decimalFormat);
            }
            return ObjectWriterArrayFinal.DECIMAL_ARRAY;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    public void writeListValueJSONB(JSONWriter jsonWriter, List list) {
        throw new UnsupportedOperationException();
    }

    public void writeListValue(JSONWriter jsonWriter, List list) {
        throw new UnsupportedOperationException();
    }

    public void writeListJSONB(JSONWriter jsonWriter, List list) {
        throw new UnsupportedOperationException();
    }

    public void writeList(JSONWriter jsonWriter, List list) {
        throw new UnsupportedOperationException();
    }

    public void writeListStr(JSONWriter jsonWriter, boolean writeFieldName, List<String> list) {
        throw new UnsupportedOperationException();
    }

    static ObjectWriter getObjectWriter(Type fieldType, Class fieldClass, String format, Locale locale, Class valueClass) {
        String className;
        if (Map.class.isAssignableFrom(valueClass)) {
            if (fieldClass.isAssignableFrom(valueClass)) {
                return ObjectWriterImplMap.of(fieldType, valueClass);
            }
            return ObjectWriterImplMap.of(valueClass);
        }
        if (Calendar.class.isAssignableFrom(valueClass)) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplCalendar.INSTANCE;
            }
            return new ObjectWriterImplCalendar(format, locale);
        }
        if (ZonedDateTime.class.isAssignableFrom(valueClass)) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplZonedDateTime.INSTANCE;
            }
            return new ObjectWriterImplZonedDateTime(format, locale);
        }
        if (LocalDateTime.class.isAssignableFrom(valueClass)) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(LocalDateTime.class);
            if (objectWriter != null && objectWriter != ObjectWriterImplLocalDateTime.INSTANCE) {
                return objectWriter;
            }
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplLocalDateTime.INSTANCE;
            }
            return new ObjectWriterImplLocalDateTime(format, locale);
        }
        if (LocalDate.class.isAssignableFrom(valueClass)) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(LocalDate.class);
            if (objectWriter != null && objectWriter != ObjectWriterImplLocalDate.INSTANCE) {
                return objectWriter;
            }
            return ObjectWriterImplLocalDate.of(format, locale);
        }
        if (LocalTime.class.isAssignableFrom(valueClass)) {
            ObjectWriter objectWriter = JSONFactory.getDefaultObjectWriterProvider().getObjectWriter(LocalTime.class);
            if (objectWriter != null && objectWriter != ObjectWriterImplLocalTime.INSTANCE) {
                return objectWriter;
            }
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplLocalTime.INSTANCE;
            }
            return new ObjectWriterImplLocalTime(format, locale);
        }
        if (Instant.class == valueClass) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplInstant.INSTANCE;
            }
            return new ObjectWriterImplInstant(format, locale);
        }
        if (BigDecimal.class == valueClass) {
            if (format == null || format.isEmpty()) {
                return ObjectWriterImplBigDecimal.INSTANCE;
            }
            return new ObjectWriterImplBigDecimal(new DecimalFormat(format), null);
        }
        if (BigDecimal[].class == valueClass) {
            if (format == null || format.isEmpty()) {
                return new ObjectWriterArrayFinal(BigDecimal.class, null);
            }
            return new ObjectWriterArrayFinal(BigDecimal.class, new DecimalFormat(format));
        }
        if (Optional.class == valueClass) {
            return ObjectWriterImplOptional.of(format, locale);
        }
        switch (className = valueClass.getName()) {
            case "java.sql.Time": {
                return JdbcSupport.createTimeWriter(format);
            }
            case "java.sql.Date": {
                return new ObjectWriterImplDate(format, locale);
            }
            case "java.sql.Timestamp": {
                return JdbcSupport.createTimestampWriter(valueClass, format);
            }
            case "org.joda.time.LocalDate": {
                return JodaSupport.createLocalDateWriter(valueClass, format);
            }
            case "org.joda.time.LocalDateTime": {
                return JodaSupport.createLocalDateTimeWriter(valueClass, format);
            }
        }
        return null;
    }

    public Function getFunction() {
        return null;
    }
}

