/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.writer.FieldWriterInt32;
import java.lang.reflect.Field;

final class FieldWriterInt32Val<T>
extends FieldWriterInt32<T> {
    FieldWriterInt32Val(String name, int ordinal, long features, String format, String label, Field field) {
        super(name, ordinal, features, format, label, Integer.TYPE, Integer.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        return this.getFieldValueInt(object);
    }

    public int getFieldValueInt(T object) {
        if (object == null) {
            throw new JSONException("field.get error, " + this.fieldName);
        }
        try {
            int value2 = this.fieldOffset != -1L ? JDKUtils.UNSAFE.getInt(object, this.fieldOffset) : this.field.getInt(object);
            return value2;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        int value2 = this.getFieldValueInt(object);
        if (value2 == 0 && jsonWriter.isEnabled(JSONWriter.Feature.NotWriteDefaultValue)) {
            return false;
        }
        this.writeInt32(jsonWriter, value2);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        int value2 = this.getFieldValueInt(object);
        jsonWriter.writeInt32(value2);
    }
}

