/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http;

import com.gexin.rp.sdk.base.uitls.Base64Util;
import com.gexin.rp.sdk.http.IGtHttpProxy;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;

public class GtHttpProxy {
    IGtHttpProxy iproxy;
    private boolean authProxy;
    private boolean proxy;

    public GtHttpProxy(IGtHttpProxy proxy) {
        String ip;
        this.iproxy = proxy;
        if (proxy.getUsername() == null) {
            proxy.setUsername("");
        }
        if (proxy.getPassword() == null) {
            proxy.setPassword("");
        }
        if ((ip = proxy.getHost()) != null && ip.length() > 1) {
            this.authProxy = proxy.getUsername().length() > 0 || proxy.getPassword().length() > 0;
            this.proxy = true;
        } else {
            this.proxy = false;
        }
    }

    public Proxy getProxy() {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.iproxy.getHost(), this.iproxy.getPort()));
    }

    public boolean isAuthProxy() {
        return this.authProxy;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public String getBasicAuthString() {
        String auth = this.iproxy.getUsername() + ":" + this.iproxy.getPassword();
        return "Basic " + Base64Util.getBASE64((byte[])auth.getBytes());
    }

    public Authenticator getAuthenticator() {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(GtHttpProxy.this.iproxy.getUsername(), GtHttpProxy.this.iproxy.getPassword().toCharArray());
            }
        };
    }
}

