/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json.xml;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.EscapeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;

public class JSONXMLSerializer {
    public static String toXml(Object object) throws JSONException {
        return JSONXMLSerializer.toXml(object, null);
    }

    public static String toXml(Object object, String tagName) throws JSONException {
        return JSONXMLSerializer.toXml(object, tagName, "content");
    }

    public static String toXml(Object object, String tagName, String ... contentKeys) throws JSONException {
        if (null == object) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (object instanceof JSONObject) {
            JSONXMLSerializer.appendTag(sb, tagName, false);
            ((JSONObject)object).forEach((key, value2) -> {
                if (ArrayUtil.isArray(value2)) {
                    value2 = new JSONArray(value2);
                }
                if (ArrayUtil.contains(contentKeys, key)) {
                    if (value2 instanceof JSONArray) {
                        int i = 0;
                        for (Object val : (JSONArray)value2) {
                            if (i > 0) {
                                sb.append('\n');
                            }
                            sb.append(EscapeUtil.escapeXml(val.toString()));
                            ++i;
                        }
                    } else {
                        sb.append(EscapeUtil.escapeXml(value2.toString()));
                    }
                } else if (StrUtil.isEmptyIfStr(value2)) {
                    sb.append(JSONXMLSerializer.wrapWithTag(null, key));
                } else if (value2 instanceof JSONArray) {
                    for (Object val : (JSONArray)value2) {
                        if (val instanceof JSONArray) {
                            sb.append(JSONXMLSerializer.wrapWithTag(JSONXMLSerializer.toXml(val), key));
                            continue;
                        }
                        sb.append(JSONXMLSerializer.toXml(val, key));
                    }
                } else {
                    sb.append(JSONXMLSerializer.toXml(value2, key));
                }
            });
            JSONXMLSerializer.appendTag(sb, tagName, true);
            return sb.toString();
        }
        if (ArrayUtil.isArray(object)) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            for (Object val : (JSONArray)object) {
                sb.append(JSONXMLSerializer.toXml(val, tagName == null ? "array" : tagName));
            }
            return sb.toString();
        }
        return JSONXMLSerializer.wrapWithTag(EscapeUtil.escapeXml(object.toString()), tagName);
    }

    private static void appendTag(StringBuilder sb, String tagName, boolean isEndTag) {
        if (StrUtil.isNotBlank(tagName)) {
            sb.append('<');
            if (isEndTag) {
                sb.append('/');
            }
            sb.append(tagName).append('>');
        }
    }

    private static String wrapWithTag(String content, String tagName) {
        if (StrUtil.isBlank(tagName)) {
            return StrUtil.wrap(content, "\"");
        }
        if (StrUtil.isEmpty(content)) {
            return "<" + tagName + "/>";
        }
        return "<" + tagName + ">" + content + "</" + tagName + ">";
    }
}

